"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Messaging
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChannelsSenderPage = exports.ChannelsSenderInstance = exports.ChannelsSenderContextImpl = exports.MessagingV2RcsComplianceResponse = exports.MessagingV2RcsComplianceCountryResponse = exports.MessagingV2RcsCarrier = exports.MessagingV2ChannelsSenderWebhook = exports.MessagingV2ChannelsSenderRequestsUpdate = exports.MessagingV2ChannelsSenderRequestsCreate = exports.MessagingV2ChannelsSenderProperties = exports.MessagingV2ChannelsSenderProfileGenericResponseWebsites = exports.MessagingV2ChannelsSenderProfileGenericResponsePhoneNumbers = exports.MessagingV2ChannelsSenderProfileGenericResponseEmails = exports.MessagingV2ChannelsSenderProfileGenericResponse = exports.MessagingV2ChannelsSenderProfile = exports.MessagingV2ChannelsSenderOfflineReasonsItems = exports.MessagingV2ChannelsSenderConfiguration = void 0;
exports.ChannelsSenderListInstance = ChannelsSenderListInstance;
const util_1 = require("util");
const Page_1 = __importDefault(require("../../../base/Page"));
const deserialize = require("../../../base/deserialize");
const serialize = require("../../../base/serialize");
const utility_1 = require("../../../base/utility");
/**
 * The configuration settings for creating a sender.
 */
class MessagingV2ChannelsSenderConfiguration {
}
exports.MessagingV2ChannelsSenderConfiguration = MessagingV2ChannelsSenderConfiguration;
class MessagingV2ChannelsSenderOfflineReasonsItems {
}
exports.MessagingV2ChannelsSenderOfflineReasonsItems = MessagingV2ChannelsSenderOfflineReasonsItems;
/**
 * The profile information for the sender.
 */
class MessagingV2ChannelsSenderProfile {
}
exports.MessagingV2ChannelsSenderProfile = MessagingV2ChannelsSenderProfile;
/**
 * The profile information for the sender.
 */
class MessagingV2ChannelsSenderProfileGenericResponse {
}
exports.MessagingV2ChannelsSenderProfileGenericResponse = MessagingV2ChannelsSenderProfileGenericResponse;
class MessagingV2ChannelsSenderProfileGenericResponseEmails {
}
exports.MessagingV2ChannelsSenderProfileGenericResponseEmails = MessagingV2ChannelsSenderProfileGenericResponseEmails;
class MessagingV2ChannelsSenderProfileGenericResponsePhoneNumbers {
}
exports.MessagingV2ChannelsSenderProfileGenericResponsePhoneNumbers = MessagingV2ChannelsSenderProfileGenericResponsePhoneNumbers;
class MessagingV2ChannelsSenderProfileGenericResponseWebsites {
}
exports.MessagingV2ChannelsSenderProfileGenericResponseWebsites = MessagingV2ChannelsSenderProfileGenericResponseWebsites;
/**
 * The additional properties for the sender.
 */
class MessagingV2ChannelsSenderProperties {
}
exports.MessagingV2ChannelsSenderProperties = MessagingV2ChannelsSenderProperties;
class MessagingV2ChannelsSenderRequestsCreate {
}
exports.MessagingV2ChannelsSenderRequestsCreate = MessagingV2ChannelsSenderRequestsCreate;
class MessagingV2ChannelsSenderRequestsUpdate {
}
exports.MessagingV2ChannelsSenderRequestsUpdate = MessagingV2ChannelsSenderRequestsUpdate;
/**
 * The configuration settings for webhooks.
 */
class MessagingV2ChannelsSenderWebhook {
}
exports.MessagingV2ChannelsSenderWebhook = MessagingV2ChannelsSenderWebhook;
class MessagingV2RcsCarrier {
}
exports.MessagingV2RcsCarrier = MessagingV2RcsCarrier;
class MessagingV2RcsComplianceCountryResponse {
}
exports.MessagingV2RcsComplianceCountryResponse = MessagingV2RcsComplianceCountryResponse;
/**
 * The KYC compliance information. This section consists of response to the request launch.
 */
class MessagingV2RcsComplianceResponse {
}
exports.MessagingV2RcsComplianceResponse = MessagingV2RcsComplianceResponse;
class ChannelsSenderContextImpl {
    constructor(_version, sid) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(sid)) {
            throw new Error("Parameter 'sid' is not valid.");
        }
        this._solution = { sid };
        this._uri = `/Channels/Senders/${sid}`;
    }
    remove(callback) {
        const headers = {};
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.remove({
            uri: instance._uri,
            method: "delete",
            headers,
        });
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    fetch(callback) {
        const headers = {};
        headers["Accept"] = "application/json";
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.fetch({
            uri: instance._uri,
            method: "get",
            headers,
        });
        operationPromise = operationPromise.then((payload) => new ChannelsSenderInstance(operationVersion, payload, instance._solution.sid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    update(params, headers, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        data = params;
        if (headers === null || headers === undefined) {
            headers = {};
        }
        headers["Content-Type"] = "application/json";
        headers["Accept"] = "application/json";
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.update({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new ChannelsSenderInstance(operationVersion, payload, instance._solution.sid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.ChannelsSenderContextImpl = ChannelsSenderContextImpl;
class ChannelsSenderInstance {
    constructor(_version, payload, sid) {
        this._version = _version;
        this.sid = payload.sid;
        this.status = payload.status;
        this.senderId = payload.sender_id;
        this.configuration = payload.configuration;
        this.webhook = payload.webhook;
        this.profile = payload.profile;
        this.properties = payload.properties;
        this.offlineReasons = payload.offline_reasons;
        this.compliance = payload.compliance;
        this.url = payload.url;
        this._solution = { sid: sid || this.sid };
    }
    get _proxy() {
        this._context =
            this._context ||
                new ChannelsSenderContextImpl(this._version, this._solution.sid);
        return this._context;
    }
    /**
     * Remove a ChannelsSenderInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed boolean
     */
    remove(callback) {
        return this._proxy.remove(callback);
    }
    /**
     * Fetch a ChannelsSenderInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed ChannelsSenderInstance
     */
    fetch(callback) {
        return this._proxy.fetch(callback);
    }
    update(params, callback) {
        return this._proxy.update(params, callback);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            sid: this.sid,
            status: this.status,
            senderId: this.senderId,
            configuration: this.configuration,
            webhook: this.webhook,
            profile: this.profile,
            properties: this.properties,
            offlineReasons: this.offlineReasons,
            compliance: this.compliance,
            url: this.url,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.ChannelsSenderInstance = ChannelsSenderInstance;
function ChannelsSenderListInstance(version) {
    const instance = ((sid) => instance.get(sid));
    instance.get = function get(sid) {
        return new ChannelsSenderContextImpl(version, sid);
    };
    instance._version = version;
    instance._solution = {};
    instance._uri = `/Channels/Senders`;
    instance.create = function create(params, headers, callback) {
        if (params === null || params === undefined) {
            throw new Error('Required parameter "params" missing.');
        }
        let data = {};
        data = params;
        if (headers === null || headers === undefined) {
            headers = {};
        }
        headers["Content-Type"] = "application/json";
        headers["Accept"] = "application/json";
        let operationVersion = version, operationPromise = operationVersion.create({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new ChannelsSenderInstance(operationVersion, payload));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.page = function page(params, callback) {
        if (params === null || params === undefined) {
            throw new Error('Required parameter "params" missing.');
        }
        if (params["channel"] === null || params["channel"] === undefined) {
            throw new Error("Required parameter \"params['channel']\" missing.");
        }
        let data = {};
        data["Channel"] = params["channel"];
        if (params["pageSize"] !== undefined)
            data["PageSize"] = params["pageSize"];
        if (params.pageNumber !== undefined)
            data["Page"] = params.pageNumber;
        if (params.pageToken !== undefined)
            data["PageToken"] = params.pageToken;
        const headers = {};
        headers["Accept"] = "application/json";
        let operationVersion = version, operationPromise = operationVersion.page({
            uri: instance._uri,
            method: "get",
            params: data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new ChannelsSenderPage(operationVersion, payload, instance._solution));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.each = instance._version.each;
    instance.list = instance._version.list;
    instance.getPage = function getPage(targetUrl, callback) {
        const operationPromise = instance._version._domain.twilio.request({
            method: "get",
            uri: targetUrl,
        });
        let pagePromise = operationPromise.then((payload) => new ChannelsSenderPage(instance._version, payload, instance._solution));
        pagePromise = instance._version.setPromiseCallback(pagePromise, callback);
        return pagePromise;
    };
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
class ChannelsSenderPage extends Page_1.default {
    /**
     * Initialize the ChannelsSenderPage
     *
     * @param version - Version of the resource
     * @param response - Response from the API
     * @param solution - Path solution
     */
    constructor(version, response, solution) {
        super(version, response, solution);
    }
    /**
     * Build an instance of ChannelsSenderInstance
     *
     * @param payload - Payload response from the API
     */
    getInstance(payload) {
        return new ChannelsSenderInstance(this._version, payload);
    }
    [util_1.inspect.custom](depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.ChannelsSenderPage = ChannelsSenderPage;
