import { inspect, InspectOptions } from "util";
import Page, { TwilioResponsePayload } from "../../../base/Page";
import Response from "../../../http/response";
import V2 from "../V2";
/**
 * The status of the sender.
 */
export type ChannelsSenderStatus = "CREATING" | "ONLINE" | "OFFLINE" | "PENDING_VERIFICATION" | "VERIFYING" | "ONLINE:UPDATING" | "TWILIO_REVIEW" | "DRAFT" | "STUBBED";
/**
 * The configuration settings for creating a sender.
 */
export declare class MessagingV2ChannelsSenderConfiguration {
    /**
     * The ID of the WhatsApp Business Account (WABA) to use for this sender.
     */
    "wabaId"?: string | null;
    /**
     * The verification method.
     */
    "verificationMethod"?: string | null;
    /**
     * The verification code.
     */
    "verificationCode"?: string | null;
    /**
     * The SID of the Twilio Voice application.
     */
    "voiceApplicationSid"?: string | null;
}
export declare class MessagingV2ChannelsSenderOfflineReasonsItems {
    /**
     * The error code.
     */
    "code"?: string | null;
    /**
     * The error message.
     */
    "message"?: string | null;
    /**
     * The URL to get more information about the error.
     */
    "moreInfo"?: string | null;
}
/**
 * The profile information for the sender.
 */
export declare class MessagingV2ChannelsSenderProfile {
    /**
     * The name of the sender. Required for WhatsApp senders and must follow [Meta\'s display name guidelines](https://www.facebook.com/business/help/757569725593362).
     */
    "name"?: string | null;
    /**
     * The profile about text for the sender.
     */
    "about"?: string | null;
    /**
     * The address of the sender.
     */
    "address"?: string | null;
    /**
     * The description of the sender.
     */
    "description"?: string | null;
    /**
     * The logo URL of the sender.
     */
    "logoUrl"?: string | null;
    /**
     * The banner URL of the sender.
     */
    "bannerUrl"?: string | null;
    /**
     * The privacy URL of the sender. Must be a publicly accessible HTTP or HTTPS URI associated with the sender.
     */
    "privacyUrl"?: string | null;
    /**
     * The terms of service URL of the sender.
     */
    "termsOfServiceUrl"?: string | null;
    /**
     * The color theme of the sender. Must be in hex format and have at least a 4:5:1 contrast ratio against white.
     */
    "accentColor"?: string | null;
    /**
     * The vertical of the sender. Allowed values are: - `Automotive` - `Beauty, Spa and Salon` - `Clothing and Apparel` - `Education` - `Entertainment` - `Event Planning and Service` - `Finance and Banking` - `Food and Grocery` - `Public Service` - `Hotel and Lodging` - `Medical and Health` - `Non-profit` - `Professional Services` - `Shopping and Retail` - `Travel and Transportation` - `Restaurant` - `Other`
     */
    "vertical"?: string | null;
    /**
     * The websites of the sender.
     */
    "websites"?: any | null;
    /**
     * The emails of the sender.
     */
    "emails"?: any | null;
    /**
     * The phone numbers of the sender.
     */
    "phoneNumbers"?: any | null;
}
/**
 * The profile information for the sender.
 */
export declare class MessagingV2ChannelsSenderProfileGenericResponse {
    /**
     * The name of the sender.
     */
    "name"?: string | null;
    /**
     * The profile about text for the sender.
     */
    "about"?: string | null;
    /**
     * The address of the sender.
     */
    "address"?: string | null;
    /**
     * The description of the sender.
     */
    "description"?: string | null;
    /**
     * The logo URL of the sender.
     */
    "logoUrl"?: string | null;
    /**
     * The banner URL of the sender.
     */
    "bannerUrl"?: string | null;
    /**
     * The privacy URL of the sender. Must be a publicly accessible HTTP or HTTPS URI associated with the sender.
     */
    "privacyUrl"?: string | null;
    /**
     * The terms of service URL of the sender.
     */
    "termsOfServiceUrl"?: string | null;
    /**
     * The color theme of the sender. Must be in hex format and have at least a 4:5:1 contrast ratio against white.
     */
    "accentColor"?: string | null;
    /**
     * The vertical of the sender. Allowed values are: - `Automotive` - `Beauty, Spa and Salon` - `Clothing and Apparel` - `Education` - `Entertainment` - `Event Planning and Service` - `Finance and Banking` - `Food and Grocery` - `Public Service` - `Hotel and Lodging` - `Medical and Health` - `Non-profit` - `Professional Services` - `Shopping and Retail` - `Travel and Transportation` - `Restaurant` - `Other`
     */
    "vertical"?: string | null;
    /**
     * The websites of the sender.
     */
    "websites"?: Array<MessagingV2ChannelsSenderProfileGenericResponseWebsites> | null;
    /**
     * The emails of the sender.
     */
    "emails"?: Array<MessagingV2ChannelsSenderProfileGenericResponseEmails> | null;
    /**
     * The phone numbers of the sender.
     */
    "phoneNumbers"?: Array<MessagingV2ChannelsSenderProfileGenericResponsePhoneNumbers> | null;
}
export declare class MessagingV2ChannelsSenderProfileGenericResponseEmails {
    "email"?: string;
    "label"?: string;
}
export declare class MessagingV2ChannelsSenderProfileGenericResponsePhoneNumbers {
    "phoneNumber"?: string;
    "label"?: string;
}
export declare class MessagingV2ChannelsSenderProfileGenericResponseWebsites {
    "website"?: string;
    "label"?: string;
}
/**
 * The additional properties for the sender.
 */
export declare class MessagingV2ChannelsSenderProperties {
    /**
     * The quality rating of the sender.
     */
    "qualityRating"?: string | null;
    /**
     * The messaging limit of the sender.
     */
    "messagingLimit"?: string | null;
}
export declare class MessagingV2ChannelsSenderRequestsCreate {
    /**
     * The ID of the sender in `whatsapp:<E.164_PHONE_NUMBER>` format.
     */
    "senderId": string | null;
    "configuration"?: MessagingV2ChannelsSenderConfiguration | null;
    "webhook"?: MessagingV2ChannelsSenderWebhook | null;
    "profile"?: MessagingV2ChannelsSenderProfile | null;
}
export declare class MessagingV2ChannelsSenderRequestsUpdate {
    "configuration"?: MessagingV2ChannelsSenderConfiguration | null;
    "webhook"?: MessagingV2ChannelsSenderWebhook | null;
    "profile"?: MessagingV2ChannelsSenderProfile | null;
}
/**
 * The configuration settings for webhooks.
 */
export declare class MessagingV2ChannelsSenderWebhook {
    /**
     * The URL to send the webhook to.
     */
    "callbackUrl"?: string | null;
    /**
     * The HTTP method for the webhook.
     */
    "callbackMethod"?: string | null;
    /**
     * The URL to send the fallback webhook to.
     */
    "fallbackUrl"?: string | null;
    /**
     * The HTTP method for the fallback webhook.
     */
    "fallbackMethod"?: string | null;
    /**
     * The URL to send the status callback to.
     */
    "statusCallbackUrl"?: string | null;
    /**
     * The HTTP method for the status callback.
     */
    "statusCallbackMethod"?: string | null;
}
export declare class MessagingV2RcsCarrier {
    /**
     * The name of the carrier. For example, `Verizon` or `AT&T` for US.
     */
    "name"?: string;
    "status"?: MessagingV2RcsCarrierStatus;
}
/**
 * The carrier-level status.
 */
export type MessagingV2RcsCarrierStatus = "UNKNOWN" | "UNLAUNCHED" | "CARRIER_REVIEW" | "APPROVED" | "REJECTED" | "SUSPENDED";
export declare class MessagingV2RcsComplianceCountryResponse {
    /**
     * The ISO 3166-1 alpha-2 country code.
     */
    "country": string;
    /**
     * The default compliance registration SID (e.g., from CR-Google) that applies to all countries unless overridden in the `countries` array.
     */
    "registrationSid"?: string;
    "status"?: MessagingV2RcsCountryStatus;
    "carriers"?: Array<MessagingV2RcsCarrier>;
}
/**
 * The KYC compliance information. This section consists of response to the request launch.
 */
export declare class MessagingV2RcsComplianceResponse {
    /**
     * The default compliance registration SID (e.g., from CR-Google) that applies to all countries unless overridden in the `countries` array.
     */
    "registrationSid": string;
    /**
     * A list of country-specific compliance details.
     */
    "countries"?: Array<MessagingV2RcsComplianceCountryResponse>;
}
/**
 * The country-level status. Based on the aggregation of the carrier-level status.
 */
export type MessagingV2RcsCountryStatus = "ONLINE" | "OFFLINE" | "TWILIO_REVIEW" | "PENDING_VERIFICATION";
/**
 * Options to pass to update a ChannelsSenderInstance
 */
export interface ChannelsSenderContextUpdateOptions {
    /**  */
    messagingV2ChannelsSenderRequestsUpdate?: MessagingV2ChannelsSenderRequestsUpdate;
}
/**
 * Options to pass to create a ChannelsSenderInstance
 */
export interface ChannelsSenderListInstanceCreateOptions {
    /**  */
    messagingV2ChannelsSenderRequestsCreate: MessagingV2ChannelsSenderRequestsCreate;
}
/**
 * Options to pass to each
 */
export interface ChannelsSenderListInstanceEachOptions {
    /**  */
    channel: string;
    /** The number of items to return per page. */
    pageSize?: number;
    /** Function to process each record. If this and a positional callback are passed, this one will be used */
    callback?: (item: ChannelsSenderInstance, done: (err?: Error) => void) => void;
    /** Function to be called upon completion of streaming */
    done?: Function;
    /** Upper limit for the number of records to return. each() guarantees never to return more than limit. Default is no limit */
    limit?: number;
}
/**
 * Options to pass to list
 */
export interface ChannelsSenderListInstanceOptions {
    /**  */
    channel: string;
    /** The number of items to return per page. */
    pageSize?: number;
    /** Upper limit for the number of records to return. list() guarantees never to return more than limit. Default is no limit */
    limit?: number;
}
/**
 * Options to pass to page
 */
export interface ChannelsSenderListInstancePageOptions {
    /**  */
    channel: string;
    /** The number of items to return per page. */
    pageSize?: number;
    /** Page Number, this value is simply for client state */
    pageNumber?: number;
    /** PageToken provided by the API */
    pageToken?: string;
}
export interface ChannelsSenderContext {
    /**
     * Remove a ChannelsSenderInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed boolean
     */
    remove(callback?: (error: Error | null, item?: boolean) => any): Promise<boolean>;
    /**
     * Fetch a ChannelsSenderInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed ChannelsSenderInstance
     */
    fetch(callback?: (error: Error | null, item?: ChannelsSenderInstance) => any): Promise<ChannelsSenderInstance>;
    /**
     * Update a ChannelsSenderInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed ChannelsSenderInstance
     */
    update(callback?: (error: Error | null, item?: ChannelsSenderInstance) => any): Promise<ChannelsSenderInstance>;
    /**
     * Update a ChannelsSenderInstance
     *
     * @param params - Body for request
     * @param headers - header params for request
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed ChannelsSenderInstance
     */
    update(params: MessagingV2ChannelsSenderRequestsUpdate, headers?: any, callback?: (error: Error | null, item?: ChannelsSenderInstance) => any): Promise<ChannelsSenderInstance>;
    /**
     * Provide a user-friendly representation
     */
    toJSON(): any;
    [inspect.custom](_depth: any, options: InspectOptions): any;
}
export interface ChannelsSenderContextSolution {
    sid: string;
}
export declare class ChannelsSenderContextImpl implements ChannelsSenderContext {
    protected _version: V2;
    protected _solution: ChannelsSenderContextSolution;
    protected _uri: string;
    constructor(_version: V2, sid: string);
    remove(callback?: (error: Error | null, item?: boolean) => any): Promise<boolean>;
    fetch(callback?: (error: Error | null, item?: ChannelsSenderInstance) => any): Promise<ChannelsSenderInstance>;
    update(params?: MessagingV2ChannelsSenderRequestsUpdate | ((error: Error | null, item?: ChannelsSenderInstance) => any), headers?: any, callback?: (error: Error | null, item?: ChannelsSenderInstance) => any): Promise<ChannelsSenderInstance>;
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON(): ChannelsSenderContextSolution;
    [inspect.custom](_depth: any, options: InspectOptions): string;
}
interface ChannelsSenderPayload extends TwilioResponsePayload {
    senders: ChannelsSenderResource[];
}
interface ChannelsSenderResource {
    sid: string;
    status: ChannelsSenderStatus;
    sender_id: string;
    configuration: MessagingV2ChannelsSenderConfiguration;
    webhook: MessagingV2ChannelsSenderWebhook;
    profile: MessagingV2ChannelsSenderProfileGenericResponse;
    properties: MessagingV2ChannelsSenderProperties;
    offline_reasons: Array<MessagingV2ChannelsSenderOfflineReasonsItems>;
    compliance: MessagingV2RcsComplianceResponse;
    url: string;
}
export declare class ChannelsSenderInstance {
    protected _version: V2;
    protected _solution: ChannelsSenderContextSolution;
    protected _context?: ChannelsSenderContext;
    constructor(_version: V2, payload: ChannelsSenderResource, sid?: string);
    /**
     * The SID of the sender.
     */
    sid: string;
    status: ChannelsSenderStatus;
    /**
     * The ID of the sender in `whatsapp:<E.164_PHONE_NUMBER>` format.
     */
    senderId: string;
    configuration: MessagingV2ChannelsSenderConfiguration;
    webhook: MessagingV2ChannelsSenderWebhook;
    profile: MessagingV2ChannelsSenderProfileGenericResponse;
    properties: MessagingV2ChannelsSenderProperties;
    /**
     * The reasons why the sender is offline.
     */
    offlineReasons: Array<MessagingV2ChannelsSenderOfflineReasonsItems>;
    compliance: MessagingV2RcsComplianceResponse;
    /**
     * The URL of the resource.
     */
    url: string;
    private get _proxy();
    /**
     * Remove a ChannelsSenderInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed boolean
     */
    remove(callback?: (error: Error | null, item?: boolean) => any): Promise<boolean>;
    /**
     * Fetch a ChannelsSenderInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed ChannelsSenderInstance
     */
    fetch(callback?: (error: Error | null, item?: ChannelsSenderInstance) => any): Promise<ChannelsSenderInstance>;
    /**
     * Update a ChannelsSenderInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed ChannelsSenderInstance
     */
    update(callback?: (error: Error | null, item?: ChannelsSenderInstance) => any): Promise<ChannelsSenderInstance>;
    /**
     * Update a ChannelsSenderInstance
     *
     * @param params - Body for request
     * @param headers - header params for request
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed ChannelsSenderInstance
     */
    update(params: MessagingV2ChannelsSenderRequestsUpdate, headers?: any, callback?: (error: Error | null, item?: ChannelsSenderInstance) => any): Promise<ChannelsSenderInstance>;
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON(): {
        sid: string;
        status: ChannelsSenderStatus;
        senderId: string;
        configuration: MessagingV2ChannelsSenderConfiguration;
        webhook: MessagingV2ChannelsSenderWebhook;
        profile: MessagingV2ChannelsSenderProfileGenericResponse;
        properties: MessagingV2ChannelsSenderProperties;
        offlineReasons: MessagingV2ChannelsSenderOfflineReasonsItems[];
        compliance: MessagingV2RcsComplianceResponse;
        url: string;
    };
    [inspect.custom](_depth: any, options: InspectOptions): string;
}
export interface ChannelsSenderSolution {
}
export interface ChannelsSenderListInstance {
    _version: V2;
    _solution: ChannelsSenderSolution;
    _uri: string;
    (sid: string): ChannelsSenderContext;
    get(sid: string): ChannelsSenderContext;
    /**
     * Create a ChannelsSenderInstance
     *
     * @param params - Body for request
     * @param headers - header params for request
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed ChannelsSenderInstance
     */
    create(params: MessagingV2ChannelsSenderRequestsCreate, headers?: any, callback?: (error: Error | null, item?: ChannelsSenderInstance) => any): Promise<ChannelsSenderInstance>;
    /**
     * Streams ChannelsSenderInstance records from the API.
     *
     * This operation lazily loads records as efficiently as possible until the limit
     * is reached.
     *
     * The results are passed into the callback function, so this operation is memory
     * efficient.
     *
     * If a function is passed as the first argument, it will be used as the callback
     * function.
     *
     * @param { ChannelsSenderListInstanceEachOptions } [params] - Options for request
     * @param { function } [callback] - Function to process each record
     */
    each(params: ChannelsSenderListInstanceEachOptions, callback?: (item: ChannelsSenderInstance, done: (err?: Error) => void) => void): void;
    /**
     * Retrieve a single target page of ChannelsSenderInstance records from the API.
     *
     * The request is executed immediately.
     *
     * @param { string } [targetUrl] - API-generated URL for the requested results page
     * @param { function } [callback] - Callback to handle list of records
     */
    getPage(targetUrl: string, callback?: (error: Error | null, items: ChannelsSenderPage) => any): Promise<ChannelsSenderPage>;
    /**
     * Lists ChannelsSenderInstance records from the API as a list.
     *
     * If a function is passed as the first argument, it will be used as the callback
     * function.
     *
     * @param { ChannelsSenderListInstanceOptions } [params] - Options for request
     * @param { function } [callback] - Callback to handle list of records
     */
    list(params: ChannelsSenderListInstanceOptions, callback?: (error: Error | null, items: ChannelsSenderInstance[]) => any): Promise<ChannelsSenderInstance[]>;
    /**
     * Retrieve a single page of ChannelsSenderInstance records from the API.
     *
     * The request is executed immediately.
     *
     * If a function is passed as the first argument, it will be used as the callback
     * function.
     *
     * @param { ChannelsSenderListInstancePageOptions } [params] - Options for request
     * @param { function } [callback] - Callback to handle list of records
     */
    page(params: ChannelsSenderListInstancePageOptions, callback?: (error: Error | null, items: ChannelsSenderPage) => any): Promise<ChannelsSenderPage>;
    /**
     * Provide a user-friendly representation
     */
    toJSON(): any;
    [inspect.custom](_depth: any, options: InspectOptions): any;
}
export declare function ChannelsSenderListInstance(version: V2): ChannelsSenderListInstance;
export declare class ChannelsSenderPage extends Page<V2, ChannelsSenderPayload, ChannelsSenderResource, ChannelsSenderInstance> {
    /**
     * Initialize the ChannelsSenderPage
     *
     * @param version - Version of the resource
     * @param response - Response from the API
     * @param solution - Path solution
     */
    constructor(version: V2, response: Response<string>, solution: ChannelsSenderSolution);
    /**
     * Build an instance of ChannelsSenderInstance
     *
     * @param payload - Payload response from the API
     */
    getInstance(payload: ChannelsSenderResource): ChannelsSenderInstance;
    [inspect.custom](depth: any, options: InspectOptions): string;
}
export {};
