"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var graphql_1 = require("graphql");
function defaultErrorFormatter(error) {
    var data = graphql_1.formatError(error);
    if (error.originalError &&
        error.originalError.result &&
        error.originalError.result.errors &&
        error.originalError.result.errors.length === 1) {
        var originalError = error.originalError.result.errors[0];
        if (originalError.message === error.message) {
            if (originalError.code) {
                data.code = originalError.code;
            }
            if (originalError.requestId) {
                data.requestId = originalError.requestId;
            }
        }
    }
    return data;
}
exports.defaultErrorFormatter = defaultErrorFormatter;
//# sourceMappingURL=defaultErrorFormatter.js.map