// server/models/vendor_tax.js
module.exports = (sequelize, DataTypes) => {
  const VendorTax = sequelize.define('vendor_tax',{ 
      id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
      },
      vendor_id: {
        type: DataTypes.INTEGER,
        allowNull: false,
      },
      tax_id: {
        type: DataTypes.STRING,
        allowNull: true, // optional
      },
      is_1099_eligible: {
        type: DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: false,
      },
      created_by: {
        type: DataTypes.INTEGER,
        allowNull: false,
      },
      updated_by: {
        type: DataTypes.INTEGER,
        allowNull: true,
      },
    },
    {
      tableName: "vendor_tax",
      timestamps: true,
      underscored: true,
    }
  );

  VendorTax.associate = (models) => {
    VendorTax.belongsTo(models.vendor, {
      foreignKey: "vendor_id",
      as: "vendor",
    });
  };

  return VendorTax;
};
