module.exports = (sequelize, DataTypes) => {
  const PaymentTerm = sequelize.define(
    "payment_term",
    {
      id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
      },
      term_name: {
        type: DataTypes.STRING,
        allowNull: false,
      },
      term_type: {
        type: DataTypes.STRING,
        allowNull: true,
      },
      is_inactive: {
        type: DataTypes.BOOLEAN, // better than STRING
        allowNull: true,
        defaultValue: false,
      },
      net_due_days: {
        type: DataTypes.INTEGER,
        allowNull: true,
      },
      discount_percent: {
        type: DataTypes.FLOAT, // can be decimal
        allowNull: true,
      },
      discount_if_paid_within_days: {
        type: DataTypes.INTEGER,
        allowNull: true,
      },
      net_due_day_of_month: {
        type: DataTypes.INTEGER,
        allowNull: true,
      },
      due_next_month_if_within_days: {
        type: DataTypes.INTEGER,
        allowNull: true,
      },
      date_driven_discount_percent: {
        type: DataTypes.FLOAT,
        allowNull: true,
      },
      discount_if_paid_before_day: {
        type: DataTypes.INTEGER,
        allowNull: true,
      },
      created_by: {
        type: DataTypes.INTEGER,
        allowNull: false,
      },
      updated_by: {
        type: DataTypes.INTEGER,
        allowNull: true,
      },
    },
    {
      tableName: "payment_terms",
      timestamps: true,
      underscored: true,
    }
  );

  return PaymentTerm;
};
