module.exports = function (sequelize, DataTypes) {
  const LeaveType = sequelize.define('leave_types', {
    id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },

    type_name: {
      type: DataTypes.STRING,
      allowNull: false,
    },

    leavetype: {
      type: DataTypes.STRING,
      allowNull: false,
    },

    no_of_leaves: {
      type: DataTypes.STRING,
      allowNull: false,
    },

    paid_status: {
      type: DataTypes.STRING,
      allowNull: false,
    },

    monthly_limit: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },

    color: {
      type: DataTypes.STRING,
      allowNull: false,
    },

    unit_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },

    // Entitlement fields
    effective_after: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0,
    },

    allowed_probation: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: false,
    },

    unused_leave: {
      type: DataTypes.STRING,
      allowNull: false,
    },

    over_utilization: {
      type: DataTypes.STRING,
      allowNull: false,
    },

    allowed_notice: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: false,
    },

    // Applicability fields (arrays stored as comma-separated strings)
    gender: {
      type: DataTypes.STRING,
      allowNull: false,
    },

    marital_status: {
      type: DataTypes.STRING,
      allowNull: false,
    },

    department: {
      type: DataTypes.STRING,
      allowNull: false,
    },

    designation: {
      type: DataTypes.STRING,
      allowNull: false,
    },

    user_role: {
      type: DataTypes.STRING,
      allowNull: false,
    },

    createdAt: {
      field: 'created_at',
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },

    updatedAt: {
      field: 'updated_at',
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'leave_types',
  });

  return LeaveType;
};
