module.exports = (sequelize, DataTypes) => {
  const Holiday = sequelize.define("holiday", {
    id: {
      type: DataTypes.INTEGER.UNSIGNED,
      autoIncrement: true,
      primaryKey: true
    },
    date: {
      type: DataTypes.DATEONLY,
      allowNull: false
    },
    occasion: {
      type: DataTypes.STRING(150),
      allowNull: false
    },
    employee_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,  // Important: now required per record
    },
    unit_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: true
    },
    created_by: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: DataTypes.NOW
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: DataTypes.NOW
    }
  }, {
    tableName: "holidays",
    timestamps: false,
    indexes: [
      { fields: ['employee_id'] },
      { fields: ['date'] },
      { fields: ['unit_id'] }
    ]
  });

  // In your holiday model file, at the bottom:
  Holiday.associate = function(models) {
    Holiday.belongsTo(models.employee, {
      foreignKey: 'employee_id',
      as: 'employee'
    });
  };

  return Holiday;
};