module.exports = function (sequelize, DataTypes) {
  const ClientInvoice = sequelize.define('client_invoices', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    }, 
    client_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      references: {
        model: 'clients',
        key: 'id',
      },
    },
    invoice_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      references: {
        model: 'invoices',
        key: 'id',
      },
    },
    createdAt: {
      field: 'created_at',
      type: DataTypes.DATE,
    },
    updatedAt: {
      field: 'updated_at',
      type: DataTypes.DATE,
    },
  }, {
    timestamps: true,  
    underscored: true,
    freezeTableName: true,
    tableName: 'client_invoices',
  });

  ClientInvoice.associate = function (models) {
    ClientInvoice.belongsTo(models.invoices, {
      foreignKey: 'invoice_id',
      as: 'invoice',
    });
    
    ClientInvoice.belongsTo(models.client, {
      foreignKey: 'client_id',
      as: 'client',
    });
  };

  return ClientInvoice;
};