module.exports = function (sequelize, DataTypes) {
  const Occupancy = sequelize.define('agreement', {
      id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
        primaryKey: true,
        autoIncrement: true,
      },
      unit_id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
      },
      property_id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: true,
      },
      tenant_id: {
        type: DataTypes.BIGINT.UNSIGNED,
        allowNull: true,
      },
      rent_amount: {
        type: DataTypes.FLOAT,
        allowNull: true,
      },
      deposit_amount: {
        type: DataTypes.FLOAT,
        allowNull: true,
      },
      start_date: {
        type: DataTypes.DATEONLY,
        allowNull: true,
      },
      end_date: {
        type: DataTypes.DATEONLY,
        allowNull: true,
      },
      next_incr_date: {
        type: DataTypes.DATEONLY,
        allowNull: true,
      },
      payment_frequency: {
        type: DataTypes.STRING(20),
        allowNull: true,
      },
      next_agree_amount_type: {
        type: DataTypes.STRING(20),
        allowNull: true,
      },
      next_agree_amount: {
        type: DataTypes.FLOAT,
        allowNull: true,
      },
      terms_condition: {
        type: DataTypes.TEXT,
        allowNull: true,
      },
      created_by: {
        type: DataTypes.BIGINT.UNSIGNED,
        allowNull: false,
      },
      createdAt: {
        field: 'created_at',
        type: DataTypes.DATE,
      },
      updatedAt: {
        field: 'updated_at',
        type: DataTypes.DATE,
      },
    },
    {
      timestamps: true,
      underscored: true,
      freezeTableName: true,
      tableName: 'agreements',
    }
  );

  Occupancy.associate = (models) => {
    Occupancy.belongsTo(models.property, {
      foreignKey: 'property_id',
      as: 'property',
    });

    Occupancy.belongsTo(models.tenants, {
      foreignKey: 'tenant_id',
      as: 'tenant',
    });
  };

  return Occupancy;
};
