'use strict';
module.exports = {
  up: async (queryInterface, Sequelize) => {
    await queryInterface.createTable('property', {
      id: {
        type: Sequelize.BIGINT.UNSIGNED,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
      },
      parent_id: {
        type: Sequelize.INTEGER,
        allowNull: true
      },
      franchise_id: {
        type: Sequelize.INTEGER,
        allowNull: true,
        comment: 'Franchise this property belongs to'
      },
      ownership_type: {
        type: Sequelize.STRING,
        allowNull: true,
        comment: 'Owner registering tenant or tenant registering self'
      },
      name: {
        type: Sequelize.STRING,
        allowNull: true
      },
      property_type: {
        type: Sequelize.STRING,
        allowNull: true
      },
      size: {
        type: Sequelize.STRING,
        allowNull: true
      },
      street_number: {
        type: Sequelize.STRING(500),
        allowNull: true
      },
      suite_floor: {
        type: Sequelize.STRING(500),
        allowNull: true
      },
      zip_code: {
        type: Sequelize.STRING(500),
        allowNull: true
      },
      city: {
        type: Sequelize.STRING(500),
        allowNull: true
      },
      state: {
        type: Sequelize.STRING(500),
        allowNull: true
      },
      country: {
        type: Sequelize.STRING(500),
        allowNull: true
      },
      borough: {
        type: Sequelize.STRING(100),
        allowNull: true
      },
      block: {
        type: Sequelize.STRING(100),
        allowNull: true
      },
      lot: {
        type: Sequelize.STRING(100),
        allowNull: true
      },
      parking_type: {
        type: Sequelize.STRING,
        allowNull: true
      },
      number_of_bedrooms: {
        type: Sequelize.INTEGER,
        allowNull: true
      },
      number_of_kitchens: {
        type: Sequelize.INTEGER,
        allowNull: true
      },
      number_of_bathrooms: {
        type: Sequelize.INTEGER,
        allowNull: true
      },
      rent_price: {
        type: Sequelize.DECIMAL(15, 2),
        defaultValue: 0.00
      },
      market_rent: {
        type: Sequelize.DECIMAL(15, 2),
        allowNull: true
      },
      deposit_amount: {
        type: Sequelize.DECIMAL(15, 2),
        allowNull: true
      },
      notes: {
        type: Sequelize.TEXT('long'),
        allowNull: true
      },
      created_by: {                      // Renamed from user_id
        type: Sequelize.INTEGER,
        allowNull: true
      },
      main_image: {
        type: Sequelize.STRING(1000),
        allowNull: true,
        comment: 'URL of the main property image'
      },
      additional_images: {
        type: Sequelize.JSON,
        allowNull: true,
        comment: 'Array of image URLs'
      },
      created_at: {
        allowNull: false,
        type: Sequelize.DATE,
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP')
      },
      updated_at: {
        allowNull: false,
        type: Sequelize.DATE,
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP')
      }
    });
  },

  down: async (queryInterface, Sequelize) => {
    await queryInterface.dropTable('property');
  }
};
