const models = require('./models/index.js')
const schema = require('./graphql')
const { GraphQLServer } = require('graphql-yoga')
const session = require('express-session')
const cors = require('cors')
const jwt = require('jsonwebtoken')
const http = require('http')
const https = require('https')
const express = require('express')
const bodyParser = require('body-parser')
const multer = require('multer')
const AWS = require('aws-sdk')
const fs = require('fs')
const moment = require('moment')

const env = 'staging'

const corsOptions = {
  origin: '*',
  optionsSuccessStatus: 200 // some legacy browsers (IE11, various SmartTVs) choke on 204
}

const archiver = express();
archiver.use(cors(corsOptions));
archiver.use(bodyParser.json());

const storage = multer.diskStorage({
  destination : 'uploads/',
  filename: function (req, file, cb) {
    cb(null, file.originalname);
  }
})

const upload = multer({ storage: storage });

AWS.config.update({
    accessKeyId: 'AKIASMWFHZL2PCME4OAF',
    secretAccessKey: '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',
    region: 'us-east-2',
})

const s3 = new AWS.S3();

archiver.post('/archivefile', upload.single('file'), autheticate, (req, res) => {
  archiveFile(req.file.path,
    req.auth,
    req.body.unit_id,
    req.body.date,
    req.file.filename,
    req.file.size,
    req.body.description,
    res);
})

// archiver.post('/archivefilewithexternalreference', upload.single('file'), autheticate, (req, res) => {
//   archiveFileWithExternalReference(req.file.path,
//     req.auth,
//     req.body.unit_id,
//     req.body.group,
//     req.body.external_reference,
//     req.body.type,
//     req.file.filename,
//     req.file.size,
//     req.body.description,
//     res);
// })

archiver.post('/archivefilewithexternalreference', upload.single('file'), autheticate, (req, res) => {
  console.log('BODY:', req.body);
  console.log('FILE:', req.file); 

  archiveFileWithExternalReference(
    req.file.path,
    req.auth,
    req.body.unit_id,
    req.body.group,
    req.body.external_reference,
    req.body.type,
    req.file.filename,
    req.file.size,
    req.body.description,
    res
  );
});


archiver.get('/getfile/:file_id', autheticate, (req, res) => {
  retrieveFile(req.params.file_id, res);
})

archiver.get('/gettemplate/:template_name', autheticate, (req, res) => {
  retrieveTemplate(req.params.template_name, res);
})

archiver.get('/deletefile/:file_id', autheticate, (req, res) => {
  console.log('deleteting file' + req.params.file_id);
  deleteFile(req.params.file_id, res);
})
console.log(env,"new env")
if (env === 'production') {
  const credentials = {
    key: fs.readFileSync('../ssl/server.key', 'utf8'),
    cert: fs.readFileSync('../ssl/certificate.crt', 'utf8'),
    ca: [fs.readFileSync('../ssl/ca_bundle.crt', 'utf8')]    
  }
  models.sequelize
    .sync()
    .then(function () {
       const httpsServer = https.createServer(credentials, archiver)
       httpsServer.listen(process.env.PORT, () => {
         console.log('Server running on port ' + process.env.PORT);
       });
    })
    .catch(function (e) {
      throw new Error(e)
    })
} else {
  const archiveServer = http.createServer(archiver)
  // models.sequelize
  //   .sync()
  //   .then(function () {
  //   })
  //   .catch(function (e) {
  //     throw new Error(e)
  //   })

  models.sequelize
    .sync()
    .then(function () {
      const PORT = process.env.PORT || 4001;
      archiveServer.listen(PORT, '0.0.0.0', () => {
        console.log(`Staging server running on http://0.0.0.0:${PORT}`);
      });
    })
    .catch(function (e) {
      throw new Error(e)
    })
}

function archiveFile(source, auth, unitId, date, filename, size, description, res) {
  console.log(`preparing to upload [${filename}]`)
  fs.readFile(source, async function (err, filedata) {
    const user = await models.user.findByPk(auth.userId)
    const unit = await models.unit.findByPk(unitId)
    const path = unit.name + '/' + moment(date).format('YYYY/MMMM/MMM-DD')
    const key = path + '/' + filename
    const type = 0
    const externalReference = ''
    const entry = {
      unit_id: unit.id,
      date,
      filename,
      size,
      path,
      s3_bucket: env === 'production' ? 'dream.big.holdings' : 'dream.big.holdings.staging',
      type,
      external_reference: externalReference,
      description: description,
      user_id: user.id
    }
    if (!err) {
      const putParams = {
          Bucket: env === 'production' ? 'dream.big.holdings' : 'dream.big.holdings.staging',
          Key: key,
          Body: filedata
      }
      s3.putObject(putParams, async function(err, data) {
        if (err) {
          console.log('Could nor upload the file. Error :', err)
          return res.send({ success: false })
        } else {
          fs.unlink(source, function(err, result) {
            if (err) console.log('error', err)
          })
          await models.file_archive.create(entry)
          console.log('Successfully uploaded the file')
          return res.send({ success: true })
        }
      })
    } else {
      console.log({ 'err': err })
    }
  })
}

function archiveFileWithExternalReference(source, auth, unitId, group, externalReference, type, filename, size, description, res) {
  console.log(`preparing to upload [${filename}]`);
  console.log(`externalReference`,externalReference);
  fs.readFile(source, async function (err, filedata) {
    if (err) {
      console.log({ 'err': err });
      return res.send({ success: false, error: 'File read error' });
    }

    try {
      const user = await models.user.findByPk(auth.userId);
      const unit = await models.unit.findByPk(unitId);
      const path = unit.name + '/' + group + '/' + externalReference;
      const key = path + '/' + filename;
      const date = moment().format('YYYY-MM-DD');

      const entry = {
        unit_id: unit.id,
        date,
        filename,
        size,
        path,
        s3_bucket: env === 'production' ? 'dream.big.holdings' : 'dream.big.holdings.staging',
        type,
        external_reference: externalReference,
        description,
        user_id: user.id
      };

      console.log({ record: entry });

      const putParams = {
        Bucket: entry.s3_bucket,
        Key: key,
        Body: filedata
      };

      s3.putObject(putParams, async function (err, data) {
        if (err) {
          console.log('Could not upload the file. Error:', err);
          return res.send({ success: false, error: 'S3 upload failed' });
        }

        fs.unlink(source, function (err) {
          if (err) console.log('File delete error', err);
        });

        const createdArchive = await models.file_archive.create(entry);
        console.log(createdArchive,"createdArchive")
        
        if (group === 'properties') {
          const property = await models.property.findOne({
            where: { id: entry.external_reference }
          });

          if (property) {
            console.log(`Found property with ID ${entry.external_reference}`);
            property.main_image = createdArchive.id;
            await property.save();
            console.log('property main_image updated to archive ID:', createdArchive.id);
          } else {
            console.log(`No property found with ID ${entry.external_reference}`);
          }
        }
        else if (group === 'owners') {
          const owner = await models.owner.findOne({
            where: { id: entry.external_reference }
          });

          if (owner) {
            console.log(`Found owner with ID ${entry.external_reference}`);
            owner.main_image = createdArchive.id;
            await owner.save();
            console.log('Owner main_image updated to archive ID:', createdArchive.id);
          } else {
            console.log(`No owner found with ID ${entry.external_reference}`);
          }
        }
        else if (group === 'tenants') {
          const tenants = await models.tenants.findOne({
            where: { id: entry.external_reference }
          });

          if (tenants) {
            console.log(`Found tenant with ID ${entry.external_reference}`);
            tenants.main_image = createdArchive.id;
            await tenants.save();
            console.log('tenants main_image updated to archive ID:', createdArchive.id);
          } else {
            console.log(`No tenants found with ID ${entry.external_reference}`);
          }
        }
        else if (group === 'clients')
        {
          const client = await models.client.findOne({
            where: { id: entry.external_reference }
          });

          if (client) {
            console.log(`Found client with ID ${entry.external_reference}`);
            client.main_image = createdArchive.id;
            await client.save();
            console.log('client main_image updated to archive ID:', createdArchive.id);
          } else {
            console.log(`No client found with ID ${entry.external_reference}`);
          }
        }
        else if (group === 'clientDocuments')
        { 
          const client_docs = await models.client_document.findOne({
            where: { id: entry.external_reference }
          });

          if (client_docs) {
            console.log(`Found client docs with ID ${entry.external_reference}`);
            client_docs.file_archive_id = createdArchive.id;
            await client_docs.save();
            console.log('client docs updated to archive ID:', createdArchive.id);
          } else {
            console.log(`No client found with ID ${entry.external_reference}`);
          }
        }
        else if (group === 'propertyDocuments')
        {
          const property_docs = await models.property_document.findOne({
            where: { id: entry.external_reference }
          }); 

          if (property_docs) {
            console.log(`Found property docs with ID ${entry.external_reference}`);
            property_docs.file_archive_id = createdArchive.id;
            await property_docs.save();
            console.log('property docs updated to archive ID:', createdArchive.id);
          } else {
            console.log(`No property found with ID ${entry.external_reference}`);
          }
        }
        else if (group === 'tenantDocuments')
        {
          const tenant_docs = await models.tenant_document.findOne({
            where: { id: entry.external_reference }
          }); 

          if (tenant_docs) {
            console.log(`Found tenant docs with ID ${entry.external_reference}`);
            tenant_docs.file_archive_id = createdArchive.id;
            await tenant_docs.save();
            console.log('tenant docs updated to archive ID:', createdArchive.id);
          } else {
            console.log(`No tenant found with ID ${entry.external_reference}`);
          }
        }
        else if (group === 'taskDocuments')
        {
          const task_docs = await models.task_document.findOne({
            where: { id: entry.external_reference }
          }); 
          
          if (task_docs) {
            console.log(`Found task docs with ID ${entry.external_reference}`);
            task_docs.file_archive_id = createdArchive.id;
            await task_docs.save();
            console.log('task docs updated to archive ID:', createdArchive.id);
          } else {
            console.log(`No task_docs found with ID ${entry.external_reference}`);
          }
        }
        else if (group === 'vendors')
        {
          const vendors = await models.vendor.findOne({
            where: { id: entry.external_reference }
          });

          if (vendors) {
            console.log(`Found vendors docs with ID ${entry.external_reference}`);
            vendors.main_image = createdArchive.id;
            await vendors.save();
            console.log('vendors updated to archive ID:', createdArchive.id);
          } else {
            console.log(`No vendors found with ID ${entry.external_reference}`);
          }
        }
        if (group === 'sign_consents') {
          const sign_consentDocs = await models.signConsentDocs.findOne({
            where: { id: entry.external_reference }
          });

          if (sign_consentDocs) {
            console.log(`✅ Found sign_consentDocs with ID ${entry.external_reference}`);
            sign_consentDocs.uploaded_document = createdArchive.id;
            await sign_consentDocs.save();
            console.log('Owner uploaded_document updated to archive ID:', createdArchive.id);
          } else {
            console.log(`❌ No owner found with ID ${entry.external_reference}`);
          }
        }

        console.log('Successfully uploaded and archived the file');
        return res.send({ success: true });
      });

    } catch (err) {
      console.error('Unexpected error:', err);
      return res.send({ success: false, error: 'Unexpected error occurred' });
    }
  });
}

async function retrieveFile(fileId, res) {
  const entry = await models.file_archive.findByPk(fileId)
  if (entry) {
    const params = {
      Bucket: env === 'production' ? 'dream.big.holdings' : 'dream.big.holdings.staging',
      Key: entry.path + '/' + entry.filename
    }
    s3.getObject(params, function(err, data) {
      if (err){
        return res.status(400).send({success: false, err: err})
      }
      else{
        return res.send(data.Body)
      }
    })
  } else {
    res.download('uploads/' + entry.filename)
  }
}

async function retrieveTemplate(templateName, res) {
  console.log("Template Name :", templateName)
  const params = {
    Bucket: env === 'production' ? 'dream.big.holdings' : 'dream.big.holdings.staging',
    Key: 'templates/' + templateName
  }
  s3.getObject(params, function(err, data) {
    if (err){
      console.log("Fetch Error :", err)
      return res.status(400).send({success: false, err: err})
    }
    else{
      console.log("Fetch data body :", data.Body)
      return res.send(data.Body)
    }
  })
}

async function deleteFile(fileId, res) {
  const entry = await models.file_archive.findByPk(fileId)
  console.log('delete: ' + entry);
  if (entry) {
    key = entry.path + '/' + entry.filename
    const params = {
      Bucket: env === 'production' ? 'dream.big.holdings' : 'dream.big.holdings.staging',
      Key: key
    }
    s3.deleteObject(params, function(err, data) {
      if (err){
        console.error('Failed to delete file', key, err)
        return res.status(400).send({success: false, err: err})
      }
      else{
        models.file_archive.destroy({ where: { id: fileId }})
        console.log('Deleted file [' + key + ']')
        return res.sendStatus(200)
      }
    })
  } else  {
    res.sendStatus(404)
  }
}

function autheticate(req, res, next) {
  const bearerHeader = req.headers['authorization']
  if (bearerHeader) {
    const bearer = bearerHeader.split(' ')
    const authToken = bearer[1];
    const auth = jwt.verify(authToken, process.env.JWT_SECRET)
    if (auth) {
      req.auth = auth
      next()
    } else {
      res.sendStatus(403)
      console.log('forbidden 1')
    }
  } else {
    res.sendStatus(403)
      console.log('forbidden 2')
  }
}

