"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Assistants
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageInstance = exports.AssistantsV1ServiceAssistantSendMessageRequest = void 0;
exports.MessageListInstance = MessageListInstance;
const util_1 = require("util");
const deserialize = require("../../../../base/deserialize");
const serialize = require("../../../../base/serialize");
const utility_1 = require("../../../../base/utility");
class AssistantsV1ServiceAssistantSendMessageRequest {
}
exports.AssistantsV1ServiceAssistantSendMessageRequest = AssistantsV1ServiceAssistantSendMessageRequest;
function MessageListInstance(version, id) {
    if (!(0, utility_1.isValidPathParam)(id)) {
        throw new Error("Parameter 'id' is not valid.");
    }
    const instance = {};
    instance._version = version;
    instance._solution = { id };
    instance._uri = `/Assistants/${id}/Messages`;
    instance.create = function create(params, headers, callback) {
        if (params === null || params === undefined) {
            throw new Error('Required parameter "params" missing.');
        }
        let data = {};
        data = params;
        if (headers === null || headers === undefined) {
            headers = {};
        }
        headers["Content-Type"] = "application/json";
        headers["Accept"] = "application/json";
        let operationVersion = version, operationPromise = operationVersion.create({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new MessageInstance(operationVersion, payload, instance._solution.id));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
class MessageInstance {
    constructor(_version, payload, id) {
        this._version = _version;
        this.status = payload.status;
        this.flagged = payload.flagged;
        this.aborted = payload.aborted;
        this.sessionId = payload.session_id;
        this.accountSid = payload.account_sid;
        this.body = payload.body;
        this.error = payload.error;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            status: this.status,
            flagged: this.flagged,
            aborted: this.aborted,
            sessionId: this.sessionId,
            accountSid: this.accountSid,
            body: this.body,
            error: this.error,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.MessageInstance = MessageInstance;
