"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Assistants
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssistantsToolPage = exports.AssistantsToolInstance = exports.AssistantsToolContextImpl = void 0;
exports.AssistantsToolListInstance = AssistantsToolListInstance;
const util_1 = require("util");
const Page_1 = __importDefault(require("../../../../base/Page"));
const deserialize = require("../../../../base/deserialize");
const serialize = require("../../../../base/serialize");
const utility_1 = require("../../../../base/utility");
class AssistantsToolContextImpl {
    constructor(_version, assistantId, id) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(assistantId)) {
            throw new Error("Parameter 'assistantId' is not valid.");
        }
        if (!(0, utility_1.isValidPathParam)(id)) {
            throw new Error("Parameter 'id' is not valid.");
        }
        this._solution = { assistantId, id };
        this._uri = `/Assistants/${assistantId}/Tools/${id}`;
    }
    create(callback) {
        const headers = {};
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.create({
            uri: instance._uri,
            method: "post",
            headers,
        });
        operationPromise = operationPromise.then((payload) => new AssistantsToolInstance(operationVersion, payload, instance._solution.assistantId, instance._solution.id));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    remove(callback) {
        const headers = {};
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.remove({
            uri: instance._uri,
            method: "delete",
            headers,
        });
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.AssistantsToolContextImpl = AssistantsToolContextImpl;
class AssistantsToolInstance {
    constructor(_version, payload, assistantId, id) {
        this._version = _version;
        this.accountSid = payload.account_sid;
        this.description = payload.description;
        this.enabled = payload.enabled;
        this.id = payload.id;
        this.meta = payload.meta;
        this.name = payload.name;
        this.requiresAuth = payload.requires_auth;
        this.type = payload.type;
        this.url = payload.url;
        this.dateCreated = deserialize.iso8601DateTime(payload.date_created);
        this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated);
        this._solution = { assistantId, id: id || this.id };
    }
    get _proxy() {
        this._context =
            this._context ||
                new AssistantsToolContextImpl(this._version, this._solution.assistantId, this._solution.id);
        return this._context;
    }
    /**
     * Create a AssistantsToolInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed AssistantsToolInstance
     */
    create(callback) {
        return this._proxy.create(callback);
    }
    /**
     * Remove a AssistantsToolInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed boolean
     */
    remove(callback) {
        return this._proxy.remove(callback);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            accountSid: this.accountSid,
            description: this.description,
            enabled: this.enabled,
            id: this.id,
            meta: this.meta,
            name: this.name,
            requiresAuth: this.requiresAuth,
            type: this.type,
            url: this.url,
            dateCreated: this.dateCreated,
            dateUpdated: this.dateUpdated,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.AssistantsToolInstance = AssistantsToolInstance;
function AssistantsToolListInstance(version, assistantId) {
    if (!(0, utility_1.isValidPathParam)(assistantId)) {
        throw new Error("Parameter 'assistantId' is not valid.");
    }
    const instance = ((id) => instance.get(id));
    instance.get = function get(id) {
        return new AssistantsToolContextImpl(version, assistantId, id);
    };
    instance._version = version;
    instance._solution = { assistantId };
    instance._uri = `/Assistants/${assistantId}/Tools`;
    instance.page = function page(params, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        if (params["pageSize"] !== undefined)
            data["PageSize"] = params["pageSize"];
        if (params.pageNumber !== undefined)
            data["Page"] = params.pageNumber;
        if (params.pageToken !== undefined)
            data["PageToken"] = params.pageToken;
        const headers = {};
        headers["Accept"] = "application/json";
        let operationVersion = version, operationPromise = operationVersion.page({
            uri: instance._uri,
            method: "get",
            params: data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new AssistantsToolPage(operationVersion, payload, instance._solution));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.each = instance._version.each;
    instance.list = instance._version.list;
    instance.getPage = function getPage(targetUrl, callback) {
        const operationPromise = instance._version._domain.twilio.request({
            method: "get",
            uri: targetUrl,
        });
        let pagePromise = operationPromise.then((payload) => new AssistantsToolPage(instance._version, payload, instance._solution));
        pagePromise = instance._version.setPromiseCallback(pagePromise, callback);
        return pagePromise;
    };
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
class AssistantsToolPage extends Page_1.default {
    /**
     * Initialize the AssistantsToolPage
     *
     * @param version - Version of the resource
     * @param response - Response from the API
     * @param solution - Path solution
     */
    constructor(version, response, solution) {
        super(version, response, solution);
    }
    /**
     * Build an instance of AssistantsToolInstance
     *
     * @param payload - Payload response from the API
     */
    getInstance(payload) {
        return new AssistantsToolInstance(this._version, payload, this._solution.assistantId);
    }
    [util_1.inspect.custom](depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.AssistantsToolPage = AssistantsToolPage;
