"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Assistants
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssistantsKnowledgePage = exports.AssistantsKnowledgeInstance = exports.AssistantsKnowledgeContextImpl = void 0;
exports.AssistantsKnowledgeListInstance = AssistantsKnowledgeListInstance;
const util_1 = require("util");
const Page_1 = __importDefault(require("../../../../base/Page"));
const deserialize = require("../../../../base/deserialize");
const serialize = require("../../../../base/serialize");
const utility_1 = require("../../../../base/utility");
class AssistantsKnowledgeContextImpl {
    constructor(_version, assistantId, id) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(assistantId)) {
            throw new Error("Parameter 'assistantId' is not valid.");
        }
        if (!(0, utility_1.isValidPathParam)(id)) {
            throw new Error("Parameter 'id' is not valid.");
        }
        this._solution = { assistantId, id };
        this._uri = `/Assistants/${assistantId}/Knowledge/${id}`;
    }
    create(callback) {
        const headers = {};
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.create({
            uri: instance._uri,
            method: "post",
            headers,
        });
        operationPromise = operationPromise.then((payload) => new AssistantsKnowledgeInstance(operationVersion, payload, instance._solution.assistantId, instance._solution.id));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    remove(callback) {
        const headers = {};
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.remove({
            uri: instance._uri,
            method: "delete",
            headers,
        });
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.AssistantsKnowledgeContextImpl = AssistantsKnowledgeContextImpl;
class AssistantsKnowledgeInstance {
    constructor(_version, payload, assistantId, id) {
        this._version = _version;
        this.description = payload.description;
        this.id = payload.id;
        this.accountSid = payload.account_sid;
        this.knowledgeSourceDetails = payload.knowledge_source_details;
        this.name = payload.name;
        this.status = payload.status;
        this.type = payload.type;
        this.url = payload.url;
        this.embeddingModel = payload.embedding_model;
        this.dateCreated = deserialize.iso8601DateTime(payload.date_created);
        this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated);
        this._solution = { assistantId, id: id || this.id };
    }
    get _proxy() {
        this._context =
            this._context ||
                new AssistantsKnowledgeContextImpl(this._version, this._solution.assistantId, this._solution.id);
        return this._context;
    }
    /**
     * Create a AssistantsKnowledgeInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed AssistantsKnowledgeInstance
     */
    create(callback) {
        return this._proxy.create(callback);
    }
    /**
     * Remove a AssistantsKnowledgeInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed boolean
     */
    remove(callback) {
        return this._proxy.remove(callback);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            description: this.description,
            id: this.id,
            accountSid: this.accountSid,
            knowledgeSourceDetails: this.knowledgeSourceDetails,
            name: this.name,
            status: this.status,
            type: this.type,
            url: this.url,
            embeddingModel: this.embeddingModel,
            dateCreated: this.dateCreated,
            dateUpdated: this.dateUpdated,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.AssistantsKnowledgeInstance = AssistantsKnowledgeInstance;
function AssistantsKnowledgeListInstance(version, assistantId) {
    if (!(0, utility_1.isValidPathParam)(assistantId)) {
        throw new Error("Parameter 'assistantId' is not valid.");
    }
    const instance = ((id) => instance.get(id));
    instance.get = function get(id) {
        return new AssistantsKnowledgeContextImpl(version, assistantId, id);
    };
    instance._version = version;
    instance._solution = { assistantId };
    instance._uri = `/Assistants/${assistantId}/Knowledge`;
    instance.page = function page(params, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        if (params["pageSize"] !== undefined)
            data["PageSize"] = params["pageSize"];
        if (params.pageNumber !== undefined)
            data["Page"] = params.pageNumber;
        if (params.pageToken !== undefined)
            data["PageToken"] = params.pageToken;
        const headers = {};
        headers["Accept"] = "application/json";
        let operationVersion = version, operationPromise = operationVersion.page({
            uri: instance._uri,
            method: "get",
            params: data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new AssistantsKnowledgePage(operationVersion, payload, instance._solution));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.each = instance._version.each;
    instance.list = instance._version.list;
    instance.getPage = function getPage(targetUrl, callback) {
        const operationPromise = instance._version._domain.twilio.request({
            method: "get",
            uri: targetUrl,
        });
        let pagePromise = operationPromise.then((payload) => new AssistantsKnowledgePage(instance._version, payload, instance._solution));
        pagePromise = instance._version.setPromiseCallback(pagePromise, callback);
        return pagePromise;
    };
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
class AssistantsKnowledgePage extends Page_1.default {
    /**
     * Initialize the AssistantsKnowledgePage
     *
     * @param version - Version of the resource
     * @param response - Response from the API
     * @param solution - Path solution
     */
    constructor(version, response, solution) {
        super(version, response, solution);
    }
    /**
     * Build an instance of AssistantsKnowledgeInstance
     *
     * @param payload - Payload response from the API
     */
    getInstance(payload) {
        return new AssistantsKnowledgeInstance(this._version, payload, this._solution.assistantId);
    }
    [util_1.inspect.custom](depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.AssistantsKnowledgePage = AssistantsKnowledgePage;
