import * as lambda from 'aws-lambda';
import { GraphQLOptions } from 'apollo-server-core';
import * as GraphiQL from 'apollo-server-module-graphiql';
export interface LambdaGraphQLOptionsFunction {
    (event: any, context: lambda.Context): GraphQLOptions | Promise<GraphQLOptions>;
}
export interface LambdaHandler {
    (event: any, context: lambda.Context, callback: lambda.Callback): void;
}
export interface IHeaders {
    [header: string]: string | number;
}
export declare function graphqlLambda(options: GraphQLOptions | LambdaGraphQLOptionsFunction): LambdaHandler;
export interface LambdaGraphiQLOptionsFunction {
    (event: any, context: lambda.Context): GraphiQL.GraphiQLData | Promise<GraphiQL.GraphiQLData>;
}
export declare function graphiqlLambda(options: GraphiQL.GraphiQLData | LambdaGraphiQLOptionsFunction): (event: any, lambdaContext: lambda.Context, callback: lambda.Callback<any>) => void;
