module.exports = function (sequelize, DataTypes) {
  const ShiftAttendance = sequelize.define('shift_roster', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      primaryKey: true,
      autoIncrement: true,
      allowNull: false,
    },
    employee_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
    },
    date: {
      type: DataTypes.DATEONLY,
      allowNull: false,
    },
    employee_shift_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
    },
    unit_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
    },
    added_by: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: true,
    },
    remarks: {
      type: DataTypes.TEXT('long'),
      allowNull: true,
    },
    send_email: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: false,
    },
    is_strict: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: false,
    },
    location: {
      type: DataTypes.STRING(100),
      allowNull: false,
      defaultValue: '',
    },
    createdAt: {
      field: 'created_at',
      type: DataTypes.DATE,
    },
    updatedAt: {
      field: 'updated_at',
      type: DataTypes.DATE,
    },
  },
    {
      timestamps: true,
      underscored: true,
      freezeTableName: true,
      tableName: 'shift_roster',
    }
  );

  ShiftAttendance.associate = function (models) {
    ShiftAttendance.belongsTo(models.employee, {
      foreignKey: 'employee_id',
      as: 'employee'
    });

    ShiftAttendance.belongsTo(models.employee_shift, {
      foreignKey: 'employee_shift_id',
      as: 'employee_shift'
    });

    ShiftAttendance.hasMany(models.employee_attendance, {
      foreignKey: 'employee_id',
      scope: {
        date: sequelize.col('shift_roster.date')
      },
      as: 'attendances'
    });

  };

  return ShiftAttendance;
};