module.exports = function (sequelize, DataTypes) {
  const RecurringInvoices = sequelize.define('recurring_invoices', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    unit_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
    },
    issue_date: {
      type: DataTypes.DATE,
      allowNull: false,
    },
    due_date: {
      type: DataTypes.DATE,
      allowNull: false,
    },
    frequency: {
      type: DataTypes.STRING(100),
      allowNull: false,
    },
    next_date: {
      type: DataTypes.DATE,
      allowNull: false,
    },
    note: {
      type: DataTypes.TEXT('long'),
      allowNull: true,
    },
    subtotal: {
      type: DataTypes.DOUBLE(15, 2),
      defaultValue: 0.00,
    },
    discount_type: {
      type: DataTypes.STRING(10),
      allowNull: true,
    },
    discount: {
      type: DataTypes.DOUBLE(15, 2),
      defaultValue: 0.00,
    },
    total: {
      type: DataTypes.DOUBLE(15, 2),
      defaultValue: 0.00,
    },
    send_email: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    print_invoice: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    print_fax: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    type: {
      type: DataTypes.ENUM('client', 'tenant'),
      allowNull: false,
      defaultValue: 'tenant',
    },
    created_by: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
    },
    createdAt: {
      field: 'created_at',
      type: DataTypes.DATE,
    },
    updatedAt: {
      field: 'updated_at',
      type: DataTypes.DATE,
    },
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'recurring_invoices',
  }); 

  RecurringInvoices.associate = function (models) {
    RecurringInvoices.hasMany(models.recurring_invoice_items, {
      foreignKey: 'recurring_invoice_id',
      as: 'items',
      onDelete: 'CASCADE',
      hooks: true,
    });

    RecurringInvoices.hasMany(models.client_recurring_invoices, {
      foreignKey: 'recurring_invoice_id',
      as: 'client_recurring_invoices',
      onDelete: 'CASCADE',
    });

    RecurringInvoices.hasMany(models.tenant_recurring_invoices, {
      foreignKey: 'recurring_invoice_id',
      as: 'tenant_recurring_invoices',
      onDelete: 'CASCADE',
    });
  };

  return RecurringInvoices;
};