/* jshint indent: 2 */

module.exports = function(sequelize, DataTypes) {
  return sequelize.define('payroll', {
    id: {
      type: DataTypes.INTEGER(10).UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    unit_id: {
      type: DataTypes.INTEGER(10).UNSIGNED,
      allowNull: false
    },
    period: {
      type: DataTypes.STRING(191),
      allowNull: false
    },
    status: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    createdAt: {
      field: 'created_at',
      type: 'TIMESTAMP'
    },
    updatedAt: {
      field: 'updated_at',
      type: 'TIMESTAMP'
    }
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'payrolls'
  });
};
