/* jshint indent: 2 */

module.exports = function (sequelize, DataTypes) {
  const attendance = sequelize.define(
    'employee_attendance',
    {
      id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
        primaryKey: true,
        autoIncrement: true,  
      },
      unit_id: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: true,
      },
      employee_id: { 
        type: DataTypes.INTEGER.UNSIGNED, 
        allowNull: false,
      },
      date: {
        type: DataTypes.DATEONLY,
        allowNull: true,
      },
      status: {
        type: DataTypes.STRING(50),
        allowNull: true,
      },
      clock_in_time: {
        type: DataTypes.DATE,
        allowNull: true,
      },
      clock_out_time: {
        type: DataTypes.DATE,
        allowNull: true,
      },
      working_from: {
        type: DataTypes.STRING(100),
        allowNull: true,
      },
      location: {
        type: DataTypes.STRING(255),
        allowNull: true,
      },
      late: {
        type: DataTypes.BOOLEAN,
        allowNull: true,
        defaultValue: false,
      },
      half_day: {
        type: DataTypes.BOOLEAN,
        allowNull: true,
        defaultValue: false,
      },
      overwrite_attendance: {
        type: DataTypes.BOOLEAN,
        allowNull: true,
        defaultValue: false,
      },
      added_by: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: true,
      },
      createdAt: {
        field: 'created_at',
        type: DataTypes.DATE,
        allowNull: false,
      },
      updatedAt: {
        field: 'updated_at',
        type: DataTypes.DATE,
        allowNull: false,
      },
    },
    {
      timestamps: true,
      underscored: true,
      freezeTableName: true,
      tableName: 'employee_attendance',
    }
  );

  // Associations
  attendance.associate = function (models) {
    attendance.belongsTo(models.unit, { foreignKey: 'unit_id', as: 'unit' });
    attendance.belongsTo(models.employee, { foreignKey: 'employee_id', as: 'employee' });
    // attendance.belongsTo(models.shift_roster, { foreignKey: 'employee_id', as: 'shift_roster' });
  };

  return attendance;
};