/* jshint indent: 2 */

module.exports = function (sequelize, DataTypes) {
  const employee = sequelize.define(
    "employee",
    {
      id: {
        type: DataTypes.INTEGER(10).UNSIGNED,
        allowNull: false,
        primaryKey: true,
        autoIncrement: true,
      },
      unit_id: {
        type: DataTypes.INTEGER(10).UNSIGNED,
        allowNull: true, // ✅ now nullable
      },
      firstname: {
        type: DataTypes.STRING(191),
        allowNull: false, // required
      },
      middlename: {
        type: DataTypes.STRING(191),
        allowNull: true,
      },
      lastname: {
        type: DataTypes.STRING(191),
        allowNull: false, // required
      },
      payroll_id: {
        type: DataTypes.STRING(191),
        allowNull: true,
      },
      address: {
        type: DataTypes.STRING(191),
        allowNull: true, // made optional
      },
      city: {
        type: DataTypes.STRING(191),
        allowNull: true,
      },
      county: {
        type: DataTypes.STRING(20),
        allowNull: true,
      },
      state: {
        type: DataTypes.STRING(191),
        allowNull: true,
      },
      zip: {
        type: DataTypes.STRING(191),
        allowNull: true,
      },
      country: {
        type: DataTypes.STRING(191),
        allowNull: true,
      },
      phone: {
        type: DataTypes.STRING(191),
        allowNull: true,
      },
      emergency_phone_number: {
        type: DataTypes.STRING(20),
        allowNull: true,
      },
      gender: {
        type: DataTypes.STRING(191),
        allowNull: true,
      },
      id_type: {
        type: DataTypes.STRING(191),
        allowNull: true,
      },
      id_number: {
        type: DataTypes.STRING(191),
        allowNull: true,
      },
      hire_date: {
        type: DataTypes.DATEONLY,
        allowNull: true,
      },
      job_title_id: {
        type: DataTypes.INTEGER(11),
        allowNull: true, // ✅ now nullable
      },
      job_title: {
        type: DataTypes.STRING(191),
        allowNull: true, // ✅ now nullable
      },
      schedule_id: {
        type: DataTypes.INTEGER(2),
        allowNull: true, // ✅ now nullable
      },
      type: {
        type: DataTypes.STRING(191),
        allowNull: true, // ✅ now nullable
      },
      department_id: {
        type: DataTypes.INTEGER(11),
        allowNull: true, // fixed type, made nullable
      },
      wage: {
        type: "DOUBLE(8,2)",
        allowNull: true, // ✅ allow empty wage
      },
      birth_date: {
        type: DataTypes.DATEONLY,
        allowNull: true,
      },
      social_security_num: {
        type: DataTypes.STRING(191),
        allowNull: true, // ✅ made optional
      },
      marital_status: {
        type: DataTypes.STRING(191), 
        allowNull: true, 
      },
      exemptions: {
        type: DataTypes.INTEGER(11),
        allowNull: true,
      },
      status: {
        type: DataTypes.STRING(191),
        allowNull: false,
        defaultValue: "Active",
      },
      termination_date: {
        type: DataTypes.DATEONLY,
        allowNull: true,
      },
      termination_reason: {
        type: DataTypes.STRING(191),
        allowNull: true,
      },
      rehire_date: {
        type: DataTypes.DATEONLY,
        allowNull: true,
      },
      createdAt: {
        field: "created_at",
        type: "TIMESTAMP",
      },
      updatedAt: {
        field: "updated_at",
        type: "TIMESTAMP",
      },
      deletedAt: {
        field: "deleted_at",
        type: "TIMESTAMP",
      },
    },
    {
      timestamps: true,
      underscored: true,
      freezeTableName: true,
      tableName: "employees",
    }
  );

  employee.associate = function (models) {
    employee.belongsTo(models.department, {
      foreignKey: "department_id",
      targetKey: "id",
      as: "department",
    });

    models.sale.belongsTo(models.unit, {
      foreignKey: "unit_id",
      targetKey: "id",
    });

    employee.hasMany(models.user_employee_map, {
      foreignKey: 'employee_id',
      as: 'user_employee_maps'
    });

    employee.hasOne(models.user_employee_map, {
      foreignKey: 'employee_id',
      as: 'user_employee_map'
    });

    employee.hasMany(models.holiday, {
      foreignKey: 'employee_id',
      as: 'holidays'
    });
  };

  return employee;
};
