// models/chart_account_type.js
module.exports = (sequelize, DataTypes) => {
  const ChartAccountType = sequelize.define('chart_account_type', {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true
    },
    title: {
      type: DataTypes.STRING(255),
      allowNull: false
    },
    unit_id: {
      type: DataTypes.STRING(10),
      allowNull: true,
      defaultValue: 'Unassigned'
    },
    status: {
      type: DataTypes.ENUM('active', 'inactive'),
      defaultValue: 'active',
      allowNull: false
    },
    createdAt: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW
    },
    updatedAt: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW
    } 
  }, {
    tableName: 'Chart_Account_type',
    timestamps: true
  });

  return ChartAccountType;
};
