'use strict';
module.exports = {
  up: async (queryInterface, Sequelize) => {
    await queryInterface.createTable('tenants', {
      id: {
        type: Sequelize.BIGINT.UNSIGNED,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
      },
      indi_corp_type: {
        type: Sequelize.STRING(500),
        allowNull: true
      },
      first_name: {
        type: Sequelize.STRING(255),
        allowNull: true
      },
      last_name: {
        type: Sequelize.STRING(500),
        allowNull: true
      },
      ssn: {
        type: Sequelize.STRING(250),
        allowNull: true
      },
      corporation_name: {
        type: Sequelize.STRING(500),
        allowNull: true
      },
      ein: {
        type: Sequelize.STRING(250),
        allowNull: true
      },
      phone: {
        type: Sequelize.STRING(100),
        allowNull: true
      },
      id_type: {
        type: Sequelize.STRING(100),
        allowNull: true
      },
      id_number: {
        type: Sequelize.STRING(100),
        allowNull: true
      },
      email: {
        type: Sequelize.STRING(250),
        allowNull: true
      },
      opening_balance: {
        type: Sequelize.DOUBLE(15, 2),
        defaultValue: 0.00
      },
      gender: {
        type: Sequelize.STRING(255),
        allowNull: true
      },
      date_of_birth: {
        type: Sequelize.STRING(250), // Or Sequelize.DATE if you want a real date
        allowNull: true
      },
      monthly_gross_income: {
        type: Sequelize.DECIMAL(15, 2),
        allowNull: true
      },
      additional_income: {
        type: Sequelize.DECIMAL(15, 2),
        allowNull: true
      },
      marital_status: {
        type: Sequelize.STRING(255),
        allowNull: true
      },
      ethnicity: {
        type: Sequelize.STRING(255),
        allowNull: true
      },
      street_number: {
        type: Sequelize.TEXT,
        allowNull: true
      },
      suite_floor: {
        type: Sequelize.TEXT,
        allowNull: true
      },
      zip_code: {
        type: Sequelize.STRING(100),
        allowNull: true
      },
      city: {
        type: Sequelize.STRING(255),
        allowNull: true
      },
      state: {
        type: Sequelize.STRING(255),
        allowNull: true
      },
      country: {
        type: Sequelize.STRING(255),
        allowNull: true
      },
      mailing_address: {
        type: Sequelize.STRING(5000),
        allowNull: true
      },
      notes: {
        type: Sequelize.TEXT('long'),
        allowNull: true
      },
      status: {
        type: Sequelize.STRING(255),
        allowNull: true
      },
      created_by: {
        type: Sequelize.BIGINT.UNSIGNED,
        allowNull: false
      },
      created_at: {
        allowNull: true,
        type: Sequelize.DATE
      },
      updated_at: {
        allowNull: true,
        type: Sequelize.DATE
      }
    });
  },

  down: async (queryInterface, Sequelize) => {
    await queryInterface.dropTable('tenants');
  }
};