'use strict';
module.exports = {
  up: async (queryInterface, Sequelize) => {
    await queryInterface.createTable('tenant_contacts', {
      id: {
        type: Sequelize.BIGINT.UNSIGNED,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
      },
      is_name_show: {
        type: Sequelize.BOOLEAN,
        defaultValue: false
      },
      tenant_id: {
        type: Sequelize.BIGINT.UNSIGNED,
        allowNull: true
      },
      first_name: {
        type: Sequelize.STRING(255),
        allowNull: true
      },
      last_name: {
        type: Sequelize.STRING(255),
        allowNull: true
      },
      ssn: {
        type: Sequelize.STRING(50),
        allowNull: true
      },
      phone: {
        type: Sequelize.STRING(100),
        allowNull: true
      },
      email: {
        type: Sequelize.STRING(255),
        allowNull: true
      },
      id_type: {
        type: Sequelize.STRING(100),
        allowNull: true
      },
      id_number: {
        type: Sequelize.STRING(100),
        allowNull: true
      },
      gender: {
        type: Sequelize.STRING(50),
        allowNull: true
      },
      date_of_birth: {
        type: Sequelize.STRING(20), // or Sequelize.DATE if preferred
        allowNull: true
      },
      monthly_gross_income: {
        type: Sequelize.DECIMAL(15, 2),
        allowNull: true
      },
      additional_income: {
        type: Sequelize.DECIMAL(15, 2),
        allowNull: true
      },
      marital_status: {
        type: Sequelize.STRING(100),
        allowNull: true
      },
      ethnicity: {
        type: Sequelize.STRING(100),
        allowNull: true
      },
      created_by: {
        type: Sequelize.BIGINT.UNSIGNED,
        allowNull: false
      },
      created_at: {
        allowNull: true,
        type: Sequelize.DATE
      },
      updated_at: {
        allowNull: true,
        type: Sequelize.DATE
      }
    });
  },

  down: async (queryInterface, Sequelize) => {
    await queryInterface.dropTable('tenant_contacts');
  }
};
