module.exports = function (sequelize, DataTypes) {
  const TaskCommentEmoji = sequelize.define('task_comment_emoji', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      autoIncrement: true, 
      primaryKey: true,
    },
    unit_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
    },
    user_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
    }, 
    comment_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
    },
    task_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
    },
    emoji_name: {
      type: DataTypes.ENUM('thumbs-up', 'thumbs-down'),
      allowNull: false,
    },
    created_by: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW, 
    },
  }, {
    timestamps: false,
    underscored: true,
    freezeTableName: true,
    tableName: 'task_comment_emoji',
  });

  TaskCommentEmoji.associate = function (models) {
    TaskCommentEmoji.belongsTo(models.task_comments, {
      foreignKey: 'comment_id',
      as: 'comment',
      onDelete: 'CASCADE',
    });
  };

  return TaskCommentEmoji;
};