module.exports = function (sequelize, DataTypes) {
  const SignConsentEmployee = sequelize.define('signconsent_employee', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    sign_consent_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    }, 
    employee_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
    },
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'signconsent_employee',
    createdAt: 'created_at',
    updatedAt: 'updated_at',
  });

  return SignConsentEmployee;
};
