module.exports = function(sequelize, DataTypes) {
  return sequelize.define('sales_food_delivery', {
    id: {
      type: DataTypes.INTEGER(10).UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    sale_id: {
      type: DataTypes.INTEGER(10).UNSIGNED,
      allowNull: false
    },
    supplier_id: {
      type: DataTypes.INTEGER(10).UNSIGNED,
      allowNull: false
    },
    supplier_title: {
      type: DataTypes.STRING(191),
      allowNull: false
    },
    description: {
      type: DataTypes.STRING(191),
      allowNull: false
    },
    amount: {
      type: "DOUBLE(8,2)",
      allowNull: false
    },
    createdAt: {
      field: 'created_at',
      type: 'TIMESTAMP'
    },
    updatedAt: {
      field: 'updated_at',
      type: 'TIMESTAMP'
    }
  },
  {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'sales_food_deliveries'
  })
}
