/* jshint indent: 2 */

module.exports = function (sequelize, DataTypes) {
  const PropertyOwners = sequelize.define('property_owners', {
    id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    owner_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: true,
    },
    property_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: true,
    },
    created_at: {
      field: 'created_at',
      type: DataTypes.DATE,
    },
    updated_at: {
      field: 'updated_at',
      type: DataTypes.DATE,
    },
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'property_owners',
  });

  return PropertyOwners;
};
