/* jshint indent: 2 */

module.exports = function (sequelize, DataTypes) {
  const Packages = sequelize.define('package', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    is_paid: {
      type: DataTypes.TINYINT(1),
      allowNull: false,
      defaultValue: 0,
    },
    is_free: {
      type: DataTypes.TINYINT(1),
      allowNull: false,
      defaultValue: 0,
    },
    name: {
      type: DataTypes.STRING(255),
      allowNull: false,
    },
    plan_type: {
      type: DataTypes.STRING(255),
      allowNull: false,
    },
     unit_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
    },
    max_employees: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
      defaultValue: 0,
    }, 
    max_storage_size: {
      type: DataTypes.INTEGER,
      allowNull: false,
    }, 
    storage_unit: {
      type: DataTypes.ENUM('gb', 'mb', 'tb'),
      allowNull: false,
      defaultValue: 'mb',
    }, 
    sort: {
      type: DataTypes.STRING(191),
      allowNull: false,
    },
    is_private: {
      type: DataTypes.TINYINT(1),
      allowNull: false,
    }, 
    is_recommended: {
      type: DataTypes.TINYINT(1),
      allowNull: false,
      defaultValue: 0,
    },
    currency_id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: true,
      references: {
        model: 'global_currency',  
        key: 'id'
      }
    },
    monthly_price: {
      type: DataTypes.DOUBLE,
      allowNull: true,
      defaultValue: 0,
    },
    annual_price: {
      type: DataTypes.DOUBLE,
      allowNull: true,
      defaultValue: 0,
    },
    module_in_package: {
      type: DataTypes.STRING(1000),
      allowNull: false,
    }, 
    description: { 
      type: DataTypes.STRING(1000),
      allowNull: true,
    },
    created_by: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
    },
    createdAt: {
      field: 'created_at',
      type: DataTypes.DATE,
      allowNull: true, 
    },
    updatedAt: {
      field: 'updated_at',
      type: DataTypes.DATE,
      allowNull: true,
    },
  }, {
    timestamps: true,
    underscored: true, 
    freezeTableName: true,
    tableName: 'packages',
  });

  // 🔗 Define association inside
  Packages.associate = function(models) {
    Packages.belongsTo(models.global_currency, {
      foreignKey: 'currency_id',
      as: 'currency'
    });
  };

  return Packages;
};
