/* jshint indent: 2 */

module.exports = function (sequelize, DataTypes) {
  const Owner = sequelize.define('owner', {
    id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    unit_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
    },
    main_image: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    property_id: {
      type: DataTypes.STRING(50),
      allowNull: false,
    },
    first_name: {
      type: DataTypes.STRING(191),
      allowNull: false,
    },
    last_name: {
      type: DataTypes.STRING(191),
      allowNull: false,
    },
    ssn: {
      type: DataTypes.STRING(191),
      allowNull: false,
    },
    phone_no: {
      type: DataTypes.STRING(20),
      allowNull: false,
    },
    email: {
      type: DataTypes.STRING(191),
      allowNull: false,
    },
    company: {
      type: DataTypes.STRING(191),
      allowNull: true,
    },
    gender: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    status: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: true,
    },
    street_number: {
      type: DataTypes.STRING(191),
      allowNull: false,
    },
    suite_floor: {
      type: DataTypes.STRING(191),
      allowNull: true,
    },
    zip_code: {
      type: DataTypes.STRING(10),
      allowNull: false,
    },
    city: {
      type: DataTypes.STRING(100),
      allowNull: false,
    },
    state: {
      type: DataTypes.STRING(100),
      allowNull: false,
    },
    country: {
      type: DataTypes.STRING(100),
      allowNull: false,
    },
    created_by: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false,
    },
    created_at: {
      field: 'created_at',
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: DataTypes.NOW,
    },
    updated_at: {
      field: 'updated_at',
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: DataTypes.NOW,
    },
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'owners',
  });

  Owner.associate = (models) => {
    Owner.belongsTo(models.property, {
      foreignKey: 'property_id',
      as: 'property',
    });
    Owner.belongsTo(models.unit, {
      foreignKey: 'unit_id',
      as: 'unit',
    });
  };

  return Owner;
};