module.exports = function (sequelize, DataTypes) {
  const InvoiceItem = sequelize.define('invoice_items', {
    id: {
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
    },
    invoice_id: { 
      type: DataTypes.BIGINT.UNSIGNED,
      allowNull: false,
    },
    code: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    title: {
      type: DataTypes.STRING(1000),
      allowNull: false,
    },
    amount: {
      type: DataTypes.DOUBLE(15, 2),
      allowNull: false,
      defaultValue: 0.00,
    },
    createdAt: {
      field: 'created_at',
      type: DataTypes.DATE,
    },
    updatedAt: {
      field: 'updated_at',
      type: DataTypes.DATE,
    },
  }, {
    timestamps: true,
    underscored: true,
    freezeTableName: true,
    tableName: 'invoice_items',
  });

  InvoiceItem.associate = function (models) {
    InvoiceItem.belongsTo(models.invoices, {
      foreignKey: 'invoice_id',
      as: 'invoice',
    });
  };

  return InvoiceItem;
};
