module.exports = (sequelize, DataTypes) => {
  const Holiday = sequelize.define("holiday", {
    id: {
      type: DataTypes.INTEGER.UNSIGNED,
      autoIncrement: true,
      primaryKey: true
    },
    department: {
      type: DataTypes.JSON,  
      allowNull: true
    },
    designation: {
      type: DataTypes.JSON,  
      allowNull: true
    },
    employee_type: {
      type: DataTypes.JSON,  
      allowNull: true
    },
    unit_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: true
    },
    date: {
      type: DataTypes.DATEONLY,
      allowNull: false
    },
    occasion: {
      type: DataTypes.STRING(150),
      allowNull: false
    },
    created_by: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: false
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: DataTypes.NOW
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: DataTypes.NOW
    }
  }, {
    tableName: "holidays",
    timestamps: false
  });

  return Holiday;
};
