module.exports = function(sequelize, DataTypes) {
  return sequelize.define('franchise_supplier', {
    id: {
      type: DataTypes.INTEGER(10).UNSIGNED,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    franchise_id: {
      type: DataTypes.INTEGER(10).UNSIGNED,
      allowNull: true
    },
    supplier_id: {
      type: DataTypes.INTEGER(10).UNSIGNED,
      allowNull: true
    },
    createdAt: {
      field: 'created_at',
      type: 'TIMESTAMP'
    },
    updatedAt: {
      field: 'updated_at',
      type: 'TIMESTAMP'
    }
  },
  {
    timestamps: false,
    underscored: true,
    freezeTableName: true,
    tableName: 'franchise_suppliers'
  })
}
