'use strict';

module.exports = (sequelize, DataTypes) => {
  const Expenses = sequelize.define('expenses', {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    expense_name: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    expense_type_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    description: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    expense_amount: {
      type: DataTypes.FLOAT,
      allowNull: false,
    },
    expense_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    status: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
  }, {
    tableName: 'expense',
    timestamps: false,
  });

  Expenses.associate = (models) => {
    Expenses.belongsTo(models.ExpenseType, {
      foreignKey: 'expense_type_id',
      as: 'expenseType'  
    });
  };

  return Expenses;
};
