module.exports = (sequelize, DataTypes) => {
  const ChartAccounts = sequelize.define("chart_of_account",
    {
      id: {
        type: DataTypes.INTEGER.UNSIGNED,
        primaryKey: true,
        autoIncrement: true,
      },
      type_id: {
        type: DataTypes.STRING,
        allowNull: false,
      },
      account: {
        type: DataTypes.STRING,
        allowNull: false,
      },
      description: {
        type: DataTypes.STRING,
        allowNull: true,
      },
      sub_account_of: {
        type: DataTypes.STRING,
        allowNull: true,
      },
      account_no: {
        type: DataTypes.STRING,
        allowNull: true,
      },
      routing_no: {
        type: DataTypes.STRING,
        allowNull: true,
      },
      check_no: {
        type: DataTypes.STRING,
        allowNull: true,
      },
      opening_balance: {
        type: DataTypes.STRING,
        allowNull: true,
      },
      tax_line_map: {
        type: DataTypes.STRING,
        allowNull: true,
      },
      note: {
        type: DataTypes.STRING,
        allowNull: true,
      },
      unit_id: {
        type: DataTypes.INTEGER,
        allowNull: true,
      },
      created_by: {
        type: DataTypes.INTEGER.UNSIGNED,
        allowNull: false,
      },
      createdAt: {
        field: 'created_at',
        type: DataTypes.DATE,
        allowNull: true,
      },
      updatedAt: {
        field: 'updated_at',
        type: DataTypes.DATE,
        allowNull: true,
      },

    },
    {
      tableName: "chart_of_accounts",
      timestamps: true,
      underscored: true,
    }
  );

  return ChartAccounts;
};
