'use strict';

module.exports = {
  async up(queryInterface, Sequelize) {
    await queryInterface.createTable('vendors', {
      id: {
        type: Sequelize.BIGINT.UNSIGNED,
        autoIncrement: true,
        primaryKey: true,
      },
      vendor_name: {
        type: Sequelize.STRING,
        allowNull: false,
      },
      opening_balance: {
        type: Sequelize.DECIMAL(15, 2),
        allowNull: false,
        defaultValue: 0,
      },
      as_of_date: {
        type: Sequelize.DATE,
        allowNull: true,
      },
      company_name: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      name_prefix: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      first_name: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      middle_initial: {
        type: Sequelize.STRING(5),
        allowNull: true,
      },
      last_name: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      job_title: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      phone: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      work_phone: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      mobile: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      fax: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      email: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      cc_email: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      website: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      other: {
        type: Sequelize.TEXT,
        allowNull: true,
      },
      billed_street: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      billed_suite: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      billed_zip: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      billed_city: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      billed_state: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      shipped_street: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      shipped_suite: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      shipped_zip: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      shipped_city: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      shipped_state: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      status: {
        type: Sequelize.STRING,
        allowNull: true,
        defaultValue: 'active',
      },
      created_by: {
        type: Sequelize.BIGINT.UNSIGNED,
        allowNull: false,
      },
      created_at: {
        type: Sequelize.DATE,
        allowNull: false,
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP'),
      },
      updated_at: {
        type: Sequelize.DATE,
        allowNull: false,
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP'),
      },
    });
  },

  async down(queryInterface) {
    await queryInterface.dropTable('vendors');
  },
};
