const { makeExecutableSchema } = require('graphql-tools')
const resolvers = require('./resolvers')
const { gql } = require('apollo-server');

const typeDefs = gql`
  scalar Date
  scalar Upload

  type Bank {
    id: Int!
    name: String!
    status: String!
    opening_balance: Float
    account_name: String
    account_no: String
    check_no: String
    routing_no: String
    description: String
    street_no: String
    zip_code: String
    city: String 
    state: String 
  }
 
  input BankInput {
    name: String!
    account_name: String!
    account_no: String!
    status: String!
    routing_no: String
    check_no: String
    opening_balance: Float
    street_no: String
    city: String
    state: String
    zip_code: String
    description: String
    unit_id: Int
  }


  type Employee {
    id: Int
    log: [EmployeeLog]
    payroll_history: [EmployeePayrollHistory]
    unit_id: Int
    unit: Unit
    firstname: String
    middlename: String
    lastname: String
    birth_date: String
    payroll_id: String
    address: String
    city: String
    county: String
    state: String
    zip: String
    country: String
    phone: String
    gender: String
    hire_date: String
    job_title_id: Int
    job_title: String
    schedule_id: Int
    type: String
    department_id: String
    department: Department
    wage: Float
    social_security_num: String
    marital_status: String
    exemptions: Int
    rehire_date: String
    status: String
    termination_date: String
    termination_reason: String
    createdAt: Date
    updatedAt: Date
    deletedAt: Date
  }
    
type Department {
  id: Int
  name: String
}
  type EmployeeChange {
    id: Int
    unit_id: Int
    unit: Unit
    employee_id: Int
    employee: Employee
    type: String
    change_title: String
    change_desc: String
    createdAt: Date
    updatedAt: Date
    deletedAt: Date
  }

  type EmployeePayrollHistory {
    id: Int
    employee_id: Int
    payroll_id: Int
    payroll: Payroll
    employee_type: String
    wages: Float
    hours: Float
    gross_wages: Float
    total_expense: Float
  }

  input EmployeeInput {
    id: Int
    unit_id: Int
    firstname: String
    middlename: String
    lastname: String
    birth_date: String
    payroll_id: String
    address: String
    city: String
    county: String
    state: String
    zip: String
    country: String
    phone: String
    gender: String
    hire_date: String
    job_title_id: Int
    job_title: String
    schedule_id: Int
    type: String
    department_id: String
    wage: Float
    social_security_num: String
    marital_status: String
    exemptions: Int
    rehire_date: String
    status: String
    termination_date: String
    termination_reason: String
  }

  type EmployeeLog {
    id: Int
    employee_id: Int
    log: String
    created_at: Date
    updated_at: Date
  }

  type EmployeePayroll {
    id: Int
    employee: Employee
    employee_id: Int
    employee_type: String
    payroll_id: Int
    payroll_ids: [Int]
    weekly_hours: [Float]
    weekly_gross_wages: [Float]
    wages: Float
    hours: Float
    overtime: Float
    gross_wages: Float
    employer_contribution: Float
    employer_liability: Float
    total_expense: Float
    unit_id: Int
    unit: Unit
    created_at: Date
    updated_at: Date
  }

  input EmployeePayrollInput {
    id: Int
    employee_id: Int
    employee_type: String
    wages: Float
    hours: Float
    gross_wages: Float
    employer_contribution: Float
    employer_liability: Float
    total_expense: Float
  }

input EmployeeUpdateInput {
  id: Int!
  firstname: String
  middlename: String        
  lastname: String
  address: String
  city: String
  state: String
  zip: String
  country: String
  phone: String
  gender: String
  job_title_id: Int
  job_title: String
  schedule_id: Int
  type: String
  wage: Float
  social_security_num: String
  marital_status: String
  exemptions: String
  status: String
  hire_date: String
  birth_date: String        
  department_id: Int
  termination_date: String
  termination_reason: String
  rehire_date: String
  payroll_id: String
  unit_id: Int
}

  type ActivitylogResponse {
    success: Boolean
    message: String
  }

  type ArchiveFile {
    id: Int
    unit_id: Int
    filename: String
    size: Int
    path: String
    s3_bucket: String
    description: String
    user_id: Int
    user: User
    created_at: Date
    updated_at: Date    
  }

  type JobTitle {
    id: Int
    title: String!
    status: String!
  }

  input JobTitleInput {
    id: Int
    title: String!
    status: String!
  }

  input PayrollInput {
    id: Int
    unit_id: Int
    period: String
    status: String
    employee_payrolls: [EmployeePayrollInput]
  }

  type EmployeeExpense {
    id: Int
    type: String!
    description: String!
    amount: Float!
    created_at: Date!
    updated_at: Date!
  }

  type Expense {
    id: Int!
    title: String!
    category: String!
    type: String!
    status: String!
  }

  input ExpenseEntryInput {
    id: Int
    title: String!
    category: String!
    type: String!
    status: String!
  }

  type ExpenseCategory {
    id: Int
    category: String
    total: Float
    expenses: [SaleExpense]
  }

  type ExpenseReport {
    id: Int
    from: Date
    to: Date
    total: Float
    expense_categories: [ExpenseCategory]
  }

  type Franchise {
    id: Int
    name: String
    payroll_period: Int
    payroll_start_day: Int
    status: Int
    suppliers: [Supplier]
  }

  input FranchiseInput {
    id: Int
    name: String!
    payroll_period: Int!
    payroll_start_day: Int!
    status: Int
    supplier_ids: [Int]
  }

  type CashReport {
    id: Int
    from: Date
    to: Date
    total: Float
    period_total: Float
    previous_total: Float
  }

  type SalesReport {
    id: Int
    from: Date
    to: Date
    cssh_report: CashReport
    sales_report: SaleAggregated
    expense_report: ExpenseReport
    deposit_report: DepositReport
    delivery_report: DeliveryReport
    payroll_report: PayrollReport
  }

  type SaleExpense {
    id: Int!
    sale_id: Int!
    expense_id: Int!
    expense_title: String!
    description: String!
    amount: Float!
    date: Date
  }

  type Deposit {
    id: Int!
    sale_id: Int!
    bank_id: Int!
    bank_title: String!
    description: String
    amount: Float!
    date: String
  }

  type DepositCategory {
    id: Int
    category: String
    total: Float
    deposits: [Deposit]
  }

  type DepositReport {
    id: Int
    from: Date
    to: Date
    total: Float
    deposit_categories: [DepositCategory]
  }

  type Payroll {
    id: Int!
    unit_id: Int!
    period: String!
    status: String!
    created_at: Date!
    updated_at: Date!
  }

  type UserGroup {
    id: Int
    name: String
    createdAt: Date
    updatedAt: Date
  }

  type User {
    id: Int
    name: String
    nick: String
    email: String
    password: String
    user_pass: String
    cutoff_date: Date
    user_group: UserGroup
    user_group_id: Int
    status: String
    remember_token: String
    access_flags: Int
    units: [Unit]
    createdAt: Date
    updatedAt: Date
  }

  input UserInput {
    id: Int
    name: String
    nick: String
    email: String
    password: String
    user_pass: String
    cutoff_date: Date
    user_group_id: Int
    status: String
    remember_token: String
    access_flags: Int
    unit_ids: [Int]
  }

  type Sale {
    id: Int
    unit_id: Int
    unit: Unit
    expenses: [SaleExpense]
    deposits: [Deposit]
    logs: [SaleLog]
    deliveries: [Delivery]
    gross_sales: Float
    tax: Float
    net_sales: Float
    net_sales_uber_eats: Float
    tax_uber_eats: Float
    net_sales_postmates: Float
    tax_postmates: Float
    credit_sales: Float
    amex_credit_sales: Float
    master_credit_sales: Float
    discover_credit_sales: Float
    visa_credit_sales: Float
    debit_sales: Float
    gift_card_redeem: Float
    gift_card_sold: Float
    donations: Float
    cash: Float
    delivery_surcharge: Float
    delivery_tips: Float
    rbi_mobile_app: Float
    uber_eats: Float
    grubhub: Float
    doordash: Float
    white_label: Float
    postmates: Float
    snackpass: Float
    transactions: Int
    voids: Int
    voids_amount: Float
    voids_percent: Float
    refunds: Int
    refunds_amount: Float
    refunds_percent: Float
    discounts: Int
    discounts_amount: Float
    discounts_percent: Float
    status: Int
    sales_date: String
    cash_in_hand: Float
    previous_cash_in_hand: Float
    total_expenses: Float
    total_deposits: Float
    createdAt: Date!
    updatedAt: Date!
  }

  type SaleAggregated {
    id: Int
    from: Date
    to: Date
    missing_count: Int
    day_count: Int
    sale: Sale
  }

  type SaleLog {
    id: Int
    sale_id: Int
    log: String
    createdAt: Date    
  }

  type Delivery {
    id: Int
    sale_id: Int
    supplier_id: Int
    supplier_title: String
    description: String
    amount: Float
    date: Date
  }

  type DeliveryCategory {
    id: Int
    category: String
    total: Float
    deliveries: [Delivery]
  }

  type DeliveryReport {
    id: Int
    from: Date
    to: Date
    total: Float
    delivery_categories: [DeliveryCategory]
  }

  type Supplier {
    id: Int!
    name: String!
    status: String!
  }

  input SupplierInput {
    id: Int
    name: String!
    status: String!
  }

  type NetSales {
    day: Int
    week: Int
    month: Int
    net_sales: Float
  }

  type UserSummary {
    from: Date
    to: Date
    total_stores: Int
    total_net_sales: Float
    total_gross_sales: Float
    total_net_sales_uber_eats: Float
    total_tax_uber_eats: Float
    total_net_sales_postmates: Float
    total_tax_postmates: Float
    total_credit_sales: Float
    total_amex_credit_sales: Float
    total_master_credit_sales: Float
    total_discover_credit_sales: Float
    total_visa_credit_sales: Float
    total_debit_sales: Float
    total_gift_card_redeem: Float
    total_gift_card_sold: Float
    total_donations: Float
    total_cash_sales: Float
    total_rbi_mobile_app: Float
    total_uber_eats: Float
    total_grubhub: Float
    total_doordash: Float
    total_white_label: Float
    total_postmates: Float
    total_snckpass: Float
    total_transactions: Int
    total_expenses: Float
    total_deliveries: Float
    total_deposits: Float
    total_deposits_count: Int
    total_deposits_dated_count: Int
    total_payrolls: Float,
    daily_net_sales: [Float]
    daily_transactions: [Int]
    payrolls: [Float]
  }

  type UserDashboard2 {
    total_stores: Int
    total_net_sales: Float
    total_transactions: Int
    total_expenses: Float
    total_deliveries: Float
    total_deposits: Float
    total_payrolls: Float,
    daily_net_sales: [Float]
    daily_transactions: [Int]
    payrolls: [Float]
  }

  type UserDashboard3 {
    last_month: UserDashboard2
    before_last_month: UserDashboard2
  }

  type UserDashboard {
    total_stores: Int
    total_net_sales_for_last_30_days: Float
    total_transactions_for_last_30_days: Int
    total_expenses_for_last_30_days: Float
    total_deliveries_for_last_30_days: Float
    total_deposits_for_last_30_days: Float
    total_wages_for_last_30_days: Float,
    daily_net_sales_for_last_30_days: [Float]
    daily_transactions_for_last_30_days: [Int]
    payrolls_for_last_30_days: [Float]
  }

  type MissingSales {
    date: Date
    unit: Unit
  }

  type MissingPayroll {
    period: Period
    unit: Unit
  }

  input DeliveryInput {
    id: Int
    sale_id: Int
    supplier_id: Int
    supplier_title: String
    description: String
    amount: Float
  }

  input DepositInput {
    id: Int
    sale_id: Int
    bank_id: Int
    bank_title: String
    description: String
    amount: Float
    date: String
  }

  input ExpenseInput {
    id: Int
    sale_id: Int
    expense_id: Int
    expense_title: String
    description: String
    amount: Float
  }

  input SaleInput {
    id: Int
    unit_id: Int
    gross_sales: Float
    tax: Float
    net_sales: Float
    net_sales_uber_eats: Float
    tax_uber_eats: Float
    net_sales_postmates: Float
    tax_postmates: Float
    credit_sales: Float
    amex_credit_sales: Float
    master_credit_sales: Float
    discover_credit_sales: Float
    visa_credit_sales: Float
    debit_sales: Float
    gift_card_redeem: Float
    gift_card_sold: Float
    donations: Float
    cash: Float
    delivery_surcharge: Float
    delivery_tips: Float
    rbi_mobile_app: Float
    uber_eats: Float
    grubhub: Float
    doordash: Float
    white_label: Float
    postmates: Float
    snackpass: Float
    transactions: Int
    voids: Int
    voids_amount: Float
    voids_percent: Float
    refunds: Int
    refunds_amount: Float
    refunds_percent: Float
    discounts: Int
    discounts_amount: Float
    discounts_percent: Float
    status: String
    sales_date: String
    createdAt: Date
  }

  type Unit {
    id: Int
    number: String
    name: String
    company_name: String
    address: String
    city: String
    state: String
    zip: String
    country: String
    phone: String
    fax: String
    contact_name: String
    contact_phone: String
    currency: String
    dma: String
    employer_contribution: Float
    payroll_client_id: String
    payroll_file_format: String
    payroll_file_name: String
    payroll_period: Int
    payroll_start_day: Int
    site_ip: String
    site_user_name: String
    site_password: String
    status: String
    createdAt: Date
    updatedAt: Date
    sales: [Sale]
    banks: [Bank]
    franchise: Franchise
  }

  input UnitInput {
    id: Int
    number: String
    name: String
    company_name: String
    address: String
    city: String
    state: String
    zip: String
    country: String
    phone: String
    fax: String
    contact_name: String
    contact_phone: String
    currency: String
    dma: String
    employer_contribution: Float
    payroll_client_id: String
    payroll_file_format: String
    payroll_file_name: String
    payroll_period: Int
    payroll_start_day: Int
    site_ip: String
    site_user_name: String
    site_password: String
    status: String
    bank_ids: [Int]
    franchise_id: Int
  }

  type LoginUser {
    id: Int!
    name: String!
    nick: String!
    email: String!
    user_group_id: Int!
    access_flags: Int!
    token: String
  }

  type SignupUserResponse {
    success: Boolean
    message: String
  }

  type deleteleaveResponse {
    success: Boolean
    message: String
  }
  
  enum PeriodType {
    DAILY
    WEEKLY
    MONTHLY
  }

  type Period {
    period: String
    display: String
    start: String
    end: String
  }

  type PayrollWeek {
    id: Int
    period: Period
    hours: Float
    amount: Float
    overtimeHours: Float
    overtimeAmount: Float
    status: String
    createdAt: Date
    updatedAt: Date
  }

  type EmployeeTypePayroll {
    type: String
    total: Float
  }

  type PayrollReport {
    id: Int
    from: Date
    to: Date
    total: Float
    payrolls: [PayrollWeek]
    employee_type_payrolls: [EmployeeTypePayroll]
  }

  type PayrollSummary {
    unit_id: Int
    unit: Unit
    period: Period
    payroll_weeks: [PayrollWeek]
    hours: Float
    amount: Float
    status: String
  }

  type UnitSummary {
    unit_id: Int
    sale_days: Int,
    unit: Unit
    gross_sales: Float
    tax: Float
    net_sales: Float
    net_sales_uber_eats: Float
    tax_uber_eats: Float
    net_sales_postmates: Float
    tax_postmates: Float
    credit_sales: Float
    amex_credit_sales: Float
    master_credit_sales: Float
    discover_credit_sales: Float
    visa_credit_sales: Float
    debit_sales: Float
    gift_card_redeem: Float
    gift_card_sold: Float
    donations: Float
    cash: Float
    rbi_mobile_app: Float
    uber_eats: Float
    grubhub: Float
    doordash: Float
    white_label: Float
    postmates: Float
    snackpass: Float
    transactions: Int
    voids: Int
    voids_amount: Float
    refunds: Int
    refunds_amount: Float
    discounts: Int
    discounts_amount: Float
    check: Float
    salary: Float
    cash_pay: Float
    expenses: Float
    deliveries: Float
    deposits: Float
    deposits_count: Int
    deposits_dated_count: Int
  }

  input AddressInput {
    street_number: String
    suite_floor: String
    zip_code: String
    city: String
    state: String
    country: String
  }

  input PropertyInput {
    id: Int
    unit_id: Int
    parent_id: Int
    property_owners: [Int]
    franchise_id: Int
    ownership_type: String
    name: String
    property_type: String
    size: String
    street_number: String
    suite_floor: String
    zip_code: String
    city: String
    state: String
    country: String
    borough: String
    block: String
    lot: String
    parking_type: String
    number_of_bedrooms: Int
    number_of_kitchens: Int
    number_of_bathrooms: Int
    rent_price: Float
    market_rent: Float
    deposit_amount: Float
    notes: String
    created_by: Int
    main_image: String
    additional_images: [String]
    property_items: [PropertyItemInput]
    property_taxes: [PropertyTaxInput]
  }

   input PropertyItemInput {
    id: Int
    property_id: Int
    property_id: Int
    included_excluded_status: Int
    name: String
    amount: Float
    item_number: String
    item_type: String
    appliance_brand: String
    appliance_model: String
    warranty_start_date: String
    warranty_end_date: String
    appliance_description: String
    utility_provider_name: String
    utility_description: String
    other_description: String
  }

  input PropertyTaxInput {
    property_id: Int
    tax_type: String
    frequency: String
    amount: Int
    next_payment_due_date: String
    reminder_before_due: String
    status: Boolean
    vendor_id: String
    payment_method: String
    payment_detail: String
    payment_date: String
    payment_ref: String
  }
    
  input PropertyDocInput {
    file: Upload!
    name: String!
    description: String
  }

   input PropertyUpdateInput {
    id: Int!
    parent_id: Int
    property_owners: [Int]
    franchise_id: Int
    ownership_type: String
    unit_id: Int
    name: String
    property_type: String
    size: String
    street_number: String
    suite_floor: String
    zip_code: String
    city: String
    state: String
    country: String
    borough: String
    block: String
    lot: String
    parking_type: String
    number_of_bedrooms: Int
    number_of_kitchens: Int
    number_of_bathrooms: Int
    rent_price: Float
    market_rent: Float
    deposit_amount: Float
    notes: String
    created_by: Int
    main_image: String
    additional_images: [String]
    property_items: [PropertyItemUpdateInput]
    property_taxes: [PropertyTaxUpdateInput]
  }

  input PropertyItemUpdateInput {
    id: Int!
    property_id: Int
    included_excluded_status: Int
    name: String
    amount: Float
    item_number: String
    item_type: String
    appliance_brand: String
    appliance_model: String
    warranty_start_date: String
    warranty_end_date: String
    appliance_description: String
    utility_provider_name: String
    utility_description: String
    other_description: String
  }
 
  input PropertyTaxUpdateInput {
    id: Int! 
    property_id: Int
    tax_type: String
    frequency: String
    amount: Int
    next_payment_due_date: String
    reminder_before_due: String
    status: Boolean
    vendor_id: String
    payment_method: String
    payment_detail: String
    payment_date: String
    payment_ref: String
  }
    
  
  type CheckDetails {
  number: String
  account: String
  routing: String
  date: String
}
 
input RevenueReceivedInput {
    tenant_id: Int
    client_id: Int
    unit_id: Int
    invoice_ids: [ID!]!
    amount: Float!
    payment_mode: String!
    type: String!
    payment_date: String!
    send_email: Boolean
    print_receipt: Boolean
    check_details: CheckDetailsInput
    card_number: String
    barter_description: String
    zelle_description: String
  }

  input CheckDetailsInput {
    number: String
    account: String
    routing: String
    date: String
  }

  type Payment {
    id: Int
    tenant_id: Int
    invoice_ids: [Int]
    amount: Float
    payment_mode: String
    payment_date: String
    send_email: Boolean
    print_receipt: Boolean
    card_number: String
    barter_description: String
    zelle_description: String
    check_details: CheckDetails  
    created_by: Int
    created_at: String
    updated_at: String
  }

  type Property {
    id: ID!
    parent_id: ID
    unit_id: Int
    name: String!
    street_number: String
    suite_floor: String
    block: String
    lot: String
    city: String
    state: String
    zip_code: String
    country: String
    property_type: String
    rent_price: Float
    market_rent: Float
    deposit_amount: Float
    number_of_bedrooms: Int
    number_of_bathrooms: Int
    number_of_kitchens: Int
    parking_type: String
    main_image: String
    notes: String
    created_at: Date
  }
  
  type PaymentTransaction {
    id: Int
    tenant_id: Int
    PaymentTenant: [PaymentTenant!]!
    invoice_ids: [Int!]!
    amount: Float!
    payment_mode: String!
    payment_date: String!
    send_email: Boolean
    print_receipt: Boolean
    check_details: PaymentCheckDetails
    card_number: String
    barter_description: String
    zelle_description: String
  }

  type PaymentTransactionClient {
    id: Int
    tenant_id: Int
    PaymentTenant: [PaymentClient!]!
    invoice_ids: [Int!]!
    amount: Float!
    payment_mode: String!
    payment_date: String!
    send_email: Boolean
    print_receipt: Boolean
    check_details: PaymentCheckDetails
    card_number: String
    barter_description: String
    zelle_description: String
  }
 
  type ClientPaymentTransaction {
    id: Int
    client_id: Int
    PaymentClient: [PaymentClient!]!
    invoice_ids: [Int!]!
    amount: Float!
    payment_mode: String!
    payment_date: String!
    send_email: Boolean
    print_receipt: Boolean
    check_details: PaymentCheckDetails
    card_number: String
    barter_description: String
    zelle_description: String
  }

  type PaymentCheckDetails {
    number: String
    account: String
    routing: String
    date: String
  }
  type PaymentClient {
    id: Int
    first_name: String
    last_name: String
  }

  type PaymentTenant {
    id: Int
    indi_corp_type: String!
    first_name: String
    last_name: String
    ssn: String
    corporation_name: String!
  }

  type Owner {
    id: Int
    first_name: String!
    last_name: String!
    ssn: String!
    phone_no: String!
    email: String!
    company: String!
    street_number: String!
    gender: String
    suite_floor: String
    zip_code: String
    city: String
    state: String
    country: String
    main_image: String
    status: String!
    created_by: Int
  }

  type property_owner {
    id: Int
    first_name: String!
    last_name: String!
    phone_no: String!
  }

  type fetch_Property_by_id {
    id: Int
    parent_id: Int
    property_owners: [property_owner]
    franchise_id: Int
    ownership_type: String
    name: String
    property_type: String
    size: String
    street_number: String
    suite_floor: String
    zip_code: String
    city: String
    state: String
    country: String
    borough: String
    block: String
    lot: String
    parking_type: String
    number_of_bedrooms: Int
    number_of_kitchens: Int
    number_of_bathrooms: Int
    rent_price: Float
    market_rent: Float
    deposit_amount: Float
    notes: String
    created_by: Int
    main_image: String
    created_at: Date
    updated_at: Date
  }

  type fetch_Client_by_id {
    id: Int
    first_name: String
    last_name: String
    ssn: String
    id_type: String
    id_number: String
    phone: String
    email: String
    gender: String
    date_of_birth: String
    opening_balance: Float
    monthly_gross_income: Float
    additional_income: Float
    marital_status: String
    ethnicity: String
    corporation_name: String
    ein: String
    street_number: String
    suite_floor: String
    zip_code: String
    city: String
    state: String
    country: String
    mailing_address: String
    notes: String
    status: String
    created_by: Int
    created_at: String
    updated_at: String
  }

  type fetch_Property_Items_by_id {
    id: Int
    property_id: Int
    included_excluded_status: Int
    name: String
    amount: Float
    item_number: String
    item_type: String
    appliance_brand: String
    appliance_model: String
    warranty_start_date: String
    warranty_end_date: String
    appliance_description: String
    utility_provider_name: String
    utility_description: String
    other_description: String
    created_at: Date
    updated_at: Date
  }

    type get_property_taxes_by_id {
    id: Int
    property_id: Int
    tax_type: String
    frequency: String
    amount: Int
    next_payment_due_date: String
    reminder_before_due: String
    status: Boolean
    vendor_id: String
    payment_method: String
    payment_detail: String
    payment_date: String
    payment_ref: String
  }

  type get_property_tax_by_id {
    id: Int
    property_id: Int
    tax_type: String
    frequency: String
    amount: Int
    next_payment_due_date: String
    reminder_before_due: String
    status: Boolean
    vendor_id: String
    payment_method: String
    payment_detail: String
    payment_date: String
    payment_ref: String
  }

  type get_property_documents_by_id {
    id: Int!
    name: String!
    file: String
    description: String
    createdAt: Date
    updatedAt: Date
  }



  type ReceiptPayment {
    id: Int
    tenant_id: Int
    client_id: Int
    amount: Float
    payment_mode: String
    send_email: Boolean
    print_receipt: Boolean
    card_number: String
    barter_description: String
    zelle_description: String
    check_details: ReceiptCheck
    PaymentClient: [PaymentClient]
    tenant: ReceiptTenant
    invoices: [ReceiptInvoice]
    createdAt: Date
  } 
  
  type ReceiptCheck {
    check_number: String
    routing_number: String
    account_number: String
    check_due_date: String
    check_status: String
  }

  type ReceiptTenant { 
    id: Int
    indi_corp_type: String
    first_name: String
    last_name: String
    corporation_name: String
  }

  type ReceiptInvoice {
    id: Int
    invoice_no: String
    subtotal: Float
    discount: Float
    discount_type: String
    total: Float
    paid_amount: Float
    balance: Float
  }

  input ContactInput {
  id: Int
  type: String
  name: String
  is_name_show: Boolean
  first_name: String
  last_name: String
  ssn: String
  phone: String
  email: String
  id_type: String
  id_number: String
  gender: String
  date_of_birth: String
  monthly_gross_income: Float
  additional_income: Float
  marital_status: String
  ethnicity: String
  relation: String
  notes: String
}


  input TenantInput {
    id: Int
    indi_corp_type: String!
    property_id: ID 
    unit_id: Int
    first_name: String
    last_name: String
    ssn: String
    corporation_name: String!
    ein: String
    phone: String
    id_type: String
    id_number: String
    email: String
    id_type: String  
    id_number: String 
    opening_balance: Float
    gender: String
    date_of_birth: String
    monthly_gross_income: Float
    additional_income: Float
    marital_status: String
    ethnicity: String
    street_number: String
    suite_floor: String
    zip_code: String
    city: String
    state: String
    country: String
    mailing_address: String
    notes: String
    status: String
    contacts: [ContactInput!]
  }

  input InvoiceItemInput {
    code: String!
    title: String!
    amount: Float!
  }

  input InvoiceInput {
    id: Int
    type: String!
    client_id: Int
    tenant_id: Int 
    invoice_no: String
    issue_date: String
    due_date: String
    items: [InvoiceItemInput!]!
    note: String
    subtotal: Float
    discount_type: String
    discount: Float 
    total: Float 
    status: String  
    send_email: Boolean 
    print_invoice: String
    print_fax: Boolean
    unit_id: Int  
    receipent_email: String
  }

  input EmployeeShiftInput {
    id: Int
    unit_id: Int!
    shift_name: String!
    shift_short_code: String!
    shift_type: String! # 'strict' | 'flexible'
    flexible_total_hours: Float
    flexible_half_day_hours: Float
    color: String 
    office_start_time: String
    office_end_time: String
    halfday_mark_time: String
    early_clock_in: Int
    late_mark_duration: Int
    clockin_in_day: Int
    office_open_days: String
    created_by: Int
  }

  # Input for creating a currency
  input CurrencyInput {
    unit_id: Int!
    currency_name: String!
    currency_symbol: String!
    currency_code: String!
    is_cryptocurrency: String!
  }

  input CurrencyUpdateInput {
    id: Int!
    unit_id: Int!
    currency_name: String
    currency_symbol: String
    currency_code: String
    is_cryptocurrency: String
  }

  type GlobalCurrency {
    id: ID!
    currency_name: String!
    currency_symbol: String!
    currency_code: String!
    is_cryptocurrency: String!
    created_by: Int!
    created_at: String
    updated_at: String
  }

  type GetTemporaryEmployees {
    id: ID! 
    first_name: String
    middle_name: String
    last_name: String
    ssn: String
    email: String
    phone_number: String
    emergency_phone_number: String
    number_and_street: String
    suite_floor: String
    zip_code: String
    city: String
    state: String
    country: String
    borough: String
    block: String
    lot: String
    gender: String
    id_type: String
    id_docs: String
    status: String
    message: String 
    created_by: String
    created_at: String
    updated_at: String
  }


  input ShiftRosterInput {
    employee_ids: [Int!]!
    dates: [String!]!    
    employee_shift_id: Int!
    remarks: String
    send_email: Int
    is_strict: Int
    location: String
    unit_id: Int!
  }

  input ShiftRosterInputSingle {
    employee_id: Int!
    date: String!
    employee_shift_id: Int!
    remarks: String
    send_email: Int
    is_strict: Int
    location: String
    unit_id: Int!
  }

  input InvitationInput {
    email: String!
    message: String!
    invite_link: String!
    otp_code: String!
    unit_id: Int
  }

  input RosterupdateInput {
    employee_id: Int!
    date: String!
    employee_shift_id: Int
    remarks: String
    send_email: Int
    is_strict: Int
    location: String
    RosterId: Int!
    unit_id: Int

  }

  type forPrintInvoices {
    id: Int
    print_invoice: String
  }

  input InvoiceInputFromMemorized {
    memorized_id: Int! 
    type: String!
    tenant_id: Int
    client_id: Int
    issue_date: String!
    due_date: String!
    items: [InvoiceItemInput!]!
    note: String
    subtotal: Float
    discount_type: String
    discount: Float
    total: Float
    status: String
    send_email: Boolean
    print_invoice: String!
    print_fax: Boolean 
    unit_id: Int
  }

  input BulkInvoiceFromMemorizedInput {
    invoices: [InvoiceInputFromMemorized!]!
  }
  
  input MemorizedInput {
    recurring_invoice_id: Int!
    invoice_pay_month: String!
    unit_id: Int
  }
  
  input RecurringInvoiceItemInput {
    code: String!
    title: String!
    amount: Float!
  }

  input RecurringInvoiceInput {
    id: Int
    type: String!
    client_id: Int
    tenant_id: Int
    issue_date: String!
    due_date: String!
    frequency: String!
    next_date: String!
    items: [RecurringInvoiceItemInput!]!
    note: String
    subtotal: Float
    discount_type: String
    discount: Float
    total: Float
    send_email: Boolean
    print_invoice: String!
    print_fax: Boolean
    unit_id: Int!
  }

  input InvoiceUpdateInput {
     id: Int
    type: String!
    client_id: Int
    tenant_id: Int 
    invoice_no: String
    issue_date: String
    due_date: String
    items: [InvoiceItemInput!]!
    note: String
    subtotal: Float
    discount_type: String
    discount: Float 
    total: Float 
    status: String  
    send_email: Boolean 
    print_invoice: String
    print_fax: Boolean
    unit_id: Int  
    receipent_email: String
  }
    
   input DesignationUpdateInput {
    id: Int
    name: String!
    parent: String
    unit_id: Int
    created_by: Int
  } 

   input DepartmentUpdateInput {
    id: Int
    name: String!
    parent: String
    unit_id: Int
    created_by: Int
  }


  type Tenant {
    id: ID!
    indi_corp_type: String!
    first_name: String
    last_name: String
    ssn: String
    corporation_name: String!
    ein: String
    phone: String
    email: String
    id_type: String  
    id_number: String 
    opening_balance: Float
    gender: String
    date_of_birth: String
    monthly_gross_income: Float
    additional_income: Float
    marital_status: String
    ethnicity: String
    street_number: String
    suite_floor: String
    zip_code: String
    city: String
    state: String
    country: String
    mailing_address: String
    notes: String
    status: String
    created_by: Int
    createdAt: Date
  }



  input OccupancyInput {
    id: Int
    tenant_id: Int
    property_id: Int
    rent_amount: Float
    deposit_amount: Float
    start_date: String
    end_date: String
    next_incr_date: String
    payment_frequency: String
    next_agree_amount_type: String
    next_agree_amount: Float
    terms_condition: String
    created_by: Int
    items: [AgreementItemInput] # ← Add this
  }

  type Occupancy {
    id: Int
    tenant_id: Int
    tenant: OccupancyTenant
    property: OccupancyProperty
    property_id: Int
    rent_amount: Float
    deposit_amount: Float
    start_date: String
    end_date: String
    next_incr_date: String
    payment_frequency: String
    next_agree_amount_type: String
    next_agree_amount: Float
    terms_condition: String
    created_by: Int
    created_at: String
    updated_at: String
  }


  type OccupancyTenant {
    indi_corp_type: String
    first_name: String
    last_name: String
    corporation_name: String
  }

  type TenantBalance {
    opening_balance: Float
  }

  type ClientBalance {
    opening_balance: Float
  }

  
type OccupancyProperty {
    name : String
  }

  type Agreement {
    id: Int
    tenant_id: Int
    property_id: Int
    rent_amount: Float
    deposit_amount: Float
    start_date: String
    end_date: String
    next_incr_date: String
    payment_frequency: String
    next_agree_amount_type: String
    next_agree_amount: Float
    terms_condition: String
  }

  type AgreementItem {
    id: Int
    included_excluded_status: String
    item_number: String
    item_type: String
    name: String
    amount: Float
    appliance_brand: String
    appliance_model: String
    warranty_start_date: String
    warranty_end_date: String
    appliance_description: String
    utility_provider_name: String
    utility_description: String
    other_description: String
  }

  type AgreementWithItems {
    agreement: Agreement
    items: [AgreementItem]
  }

  input PackageInput {
  name: String!
  plan_type: String!
  maxEmployees: Int
  maxStorageSize: Int
  storage_unit: String
  position: Int
  isPrivate: Boolean
  isRecommended: Boolean
  currency: String
  hasMonthlyPlan: Boolean
  monthlyPrice: Float
  hasAnnualPlan: Boolean
  annualPrice: Float
  description: String
  modules: [String!]
  unit_id: Int!
}
 
input PackageUpdateInput {
  id: Int!
  name: String!
  plan_type: String!
  maxEmployees: Int
  maxStorageSize: Int
  storage_unit: String
  position: Int
  isPrivate: Boolean
  isRecommended: Boolean
  currency: String
  hasMonthlyPlan: Boolean
  monthlyPrice: Float
  hasAnnualPlan: Boolean
  annualPrice: Float
  description: String
  modules: [String!]
  unit_id: Int

}

input ClientInput {
  first_name: String!
  last_name: String!
  ssn: String
  id_type: String
  id_number: String
  phone: String
  email: String
  gender: String
  date_of_birth: String
  opening_balance: Float
  monthly_gross_income: Float
  additional_income: Float
  marital_status: String
  ethnicity: String
  corporation_name: String
  ein: String
  street_number: String
  suite_floor: String
  zip_code: String
  city: String
  state: String
  country: String
  mailing_address: String
  notes: String
  status: String
  unit_id: Int!

  # Entity fields
  entity_name: String!
  entity_ein: String
  entity_email: String
  entity_phone: String!
  entity_street_number: String
  entity_suite_floor: String
  entity_zip_code: String
  entity_city: String
  entity_state: String
  entity_country: String
  service_id:String


}

input EntitiesInput {
  id: Int
  client_id: Int
  entity_name: String!
  entity_ein: String
  email: String
  service_id: String
  phone: String!
  street_number: String
  suite_floor: String
  zip_code: String
  city: String
  state: String
  country: String
}

input EntitiesUpdateInput {
  id: Int!
  client_id: Int
  entity_name: String!
  entity_ein: String
  email: String
  service_id: String
  phone: String!
  street_number: String
  suite_floor: String
  zip_code: String
  city: String
  state: String
  country: String
}

input ServiceUpdateInput {
  id: Int!
  code: String
  name: String!
  price: String
  status: String!
  description: String
  unit_id: Int

}
  
input ServiceInput {
  code: String
  name: String!
  price: Float
  status: String
  description: String
  unit_id: Int
}
  

input Employee_TaskInput {
  title: String!
  category: String
  start_date: String!
  end_date: String
  estimated_hours: Int!
  team: [Int]
  project: String
  status: String
  description: String
  unit_id: Int
}

input SubTaskInput {
  title: String!
  start_date: String!
  due_date: String
  description: String
  status: String
  task_id: Int!
  assigned_to: Int!
  assigned_by: Int!
  unit_id: Int
}

input UpdateSubTaskInput {
  id: Int!
  title: String!
  start_date: String!
  due_date: String
  description: String
  status: String
  task_id: Int!
  assigned_to: Int!
  assigned_by: Int!
  unit_id: Int
}

input UpdatesubTaskStatusInput {
  id: Int!
  status: String
  task_id: Int!
  unit_id: Int
}

input UpdateTaskStatusInput {
  id: Int!
  status: String
  unit_id: Int
}

input TaskCommentInput {
  comment: String!
  assigned_by: Int!
  unit_id: Int!
  task_id: Int!
}

input TaskNoteInput
{
  notes: String!
  assigned_by: Int!
  unit_id: Int!
  task_id: Int!
}

input ReactToCommentInput {
  comment_id: ID!
  emoji_name: String
  user_id: String!
  task_id: ID!
  unit_id: Int!
} 


input TimeSheetInput {
  id: Int
  user_id: Int!
  start_time: String!
  end_time: String
  total_time: String
  memo: String
  task_id: Int!
  project_id: Int!
  unit_id: Int
}

input VendorInput {
  vendor_name: String!
  opening_balance: Float
  as_of_date: String
  date_of_birth: String
  company_name: String
  name_prefix: String
  first_name: String
  m_i: String
  last_name: String
  job_title: String
  phone: String
  work_phone: String
  mobile: String
  fax: String
  email: String
  cc_email: String
  website: String
  otherDesc: String
  billed_street: String
  billed_suite: String
  billed_zip: String
  billed_city: String
  billed_state: String
  shipped_street: String
  shipped_suite: String
  shipped_zip: String
  shipped_city: String
  shipped_state: String
  vendor_type_id: Int
  is_inactive: Boolean
  account_no: String
  credit_limit: Float
  print_name_on_check: String
  print_sign: String
  tax_id: String
  is_1099_eligible: Boolean
  payment_terms_id: ID
  unit_id: Int 

}

input ChartAccountInput {
  type_id: String
  account: String
  description: String
  sub_account_of: String
  account_no: String
  routing_no: String
  check_no: String
  opening_balance: String
  tax_line_map: String
  note: String
  unit_id: Int 
}

input ChartAccountUpdateInput {
  id: ID!
  type_id: String
  account: String
  description: String
  sub_account_of: String
  account_no: String
  routing_no: String
  check_no: String
  opening_balance: String
  tax_line_map: String
  note: String
  unit_id: Int 
}


input VendorPaymentInput {
  id: ID
  account_no: String!
  vendor_id: ID!
  credit_limit: String
  print_name_on_check_as: String
  payment_terms_id: ID
}

input VendorTaxInput {
  id: ID
  vendor_id: String!
  tax_id: ID!
  is_1099_eligible: String
}

input CheckPaymentItemInput {
  account_id: Int
  memo: String
  amount: Float
}

input CheckPaymentInput {
  id: Int
  vendor_id: String
  bank_id: Int
  available_balance: Float
  street: String
  suit: String
  zip: String
  city: String
  state: String
  check_no: String
  total_amount: Float
  payment_date: String
  invoice_number: String
  remaining_balance: Float
  send_email: Boolean
  print_check: Boolean
  unit_id: Int
  items: [CheckPaymentItemInput]
}
  
input ExpenseTypeInput {
  id: ID
  type_name: String!
  type_date: String!
}

input ExpenseTypeUpdateInput {
  id: ID
  type_name: String!
  type_date: String!
}

input ExpensesInput {
  id: ID
  expense_name: String!
  expense_type_id: Int!
  description: String
  expense_amount: Float!
  expense_date: String
  status: String
}

input IncomeTypeInput {
  id: ID
  type_name: String!
  type_date: String!
}

input ProfileInput {
  employee_id: String!
  firstname: String
  middlename: String
  lastname: String
  phone: String
  emergency_phone_number: String
  address: String
  city: String
  state: String
  country: String
  gender: String
  social_security_num: String
  id_type: String
  id_number: String
}

input ChangePasswordInput {
  email: String!
  newPassword: String!
  user_pass: String!
}

input RefreshTokenInput {
  refreshToken: String!
}

input ResetPasswordInput {
  email: String!
  verification_code: String!
  new_password: String!
  user_pass: String!
}

input EmailInput {
  email: String!
}

input SwapInput {
  task_id: Int!
  task_assign_id: Int!
  from_employee_id: Int!
  to_employee_id: Int!
  created_by: Int!
  reason: String
  status: String!
  action: String!
}

input ForwardInput {
  task_id: Int!
  task_assign_id: Int!
  from_employee_id: Int!
  to_employee_id: Int!
  created_by: Int!
  reason: String
  status: String!
  action: String!
}

input AcceptInput {
  sign_consent_id: Int!
  employee_id: Int!
}

input AcceptInputBulk {
  employee_id: Int!
  sign_consent_ids: [Int!]!
}

input MarkApprovedTaskStatusInput {
  id: Int!
  status: Int!
  message: String
}

input MarkRejectTaskStatusInput {
  id: Int!
  status: Int!
  message: String
}


type updateProfileResponse {
  success: Boolean!
  message: String
}

type changePasswordResponse {
  success: Boolean!
  message: String
}

type ResetPasswordResponse {
  success: Boolean!
  message: String
}

type EmailInputResponse {
  success: Boolean!
  message: String
}

type SwapInputResponse {
  success: Boolean!
  message: String
}

type GetSwapTask {
  id: Int
  task_id: Int
  from_employee_id: Int
  to_employee_id: Int
  created_by: Int
  action: String
  reason: String
  status: String
}

type ForwardInputResponse {
  success: Boolean!
  message: String
}

type AcceptConsentResponse {
  success: Boolean!
  message: String
}

type AcceptConsentBulkResponse {
  success: Boolean!
  message: String
}

type CheckPayment {
  id: Int!
  vendor_id: String
  bank_id: Int
  available_balance: Float
  street: String
  suit: String
  zip: String
  city: String
  state: String
  check_no: String
  total_amount: Float
  payment_date: String
  invoice_number: String
  remaining_balance: Float
  send_email: Boolean
  print_check: Boolean
  unit_id: Int
  items: [CheckPaymentItem]
}

type CheckPaymentItem {
  account_id: Int
  memo: String
  amount: Float
}

type VendorPayment {
  id: ID!
  account_no: String
  vendor_id: ID
  credit_limit: String
  print_name_on_check_as: String
  payment_terms_id: ID
}

type VendorTax {
  id: ID!
  tax_id: String
  vendor_id: ID
  is_1099_eligible: String
}


input VendorUpdateInput {
  id: ID!
  vendor_name: String
  opening_balance: Float
  as_of_date: String
  date_of_birth: String
  company_name: String
  name_prefix: String
  first_name: String
  middle_initial: String
  last_name: String
  job_title: String
  phone: String
  work_phone: String
  mobile: String
  fax: String
  email: String
  cc_email: String
  website: String
  other: String
  billed_street: String
  billed_suite: String
  billed_zip: String
  billed_city: String
  billed_state: String
  shipped_street: String
  shipped_suite: String
  shipped_zip: String
  shipped_city: String
  shipped_state: String
  vendor_type_id: Int!
  status: String 
  unit_id: Int 

}

input VendorTypeInput {
  vendor_title: String!
  vendor_parent: String
  status: String
  unit_id: Int 

}

input VendorTypeUpdateInput {
  id: Int!
  vendor_title: String!
  vendor_parent: String
  status: String
  unit_id: Int 

}

input PaymentTermInput {
  id: ID
  term_name: String!
  term_type: String!   # "standard" or "dateDriven"
  is_inactive: Boolean

  # Standard fields
  net_due_days: Int
  discount_percent: Float
  discount_if_paid_within_days: Int

  # Date Driven fields
  net_due_day_of_month: Int
  due_next_month_if_within_days: Int
  date_driven_discount_percent: Float
  discount_if_paid_before_day: Int
}

type PaymentTerm {
  id: ID!
  term_name: String!
  term_type: String!
  is_inactive: Boolean
  net_due_days: Int
  discount_percent: Float
  discount_if_paid_within_days: Int
  net_due_day_of_month: Int
  due_next_month_if_within_days: Int
  date_driven_discount_percent: Float
  discount_if_paid_before_day: Int
  created_by: Int
  updated_by: Int
  created_at: String
  updated_at: String
}

type Package {
  id: Int!
  name: String!
  plan_type: String
  maxEmployees: Int
  maxStorageSize: Int
  storage_unit: String
  position: Int
  isPrivate: Boolean
  isRecommended: Boolean
  currency: packageCurrency
  hasMonthlyPlan: Boolean
  monthlyPrice: Float
  hasAnnualPlan: Boolean
  annualPrice: Float
  description: String
  modules: [String!]
}

type packageCurrency {
  id: ID
  currency_name: String
  currency_symbol: String
}

type VendorType {
  id: ID
  vendor_title: String
  vendor_parent: String
  status: String
}

type Vendor {
    id: ID
    vendor_name: String
    opening_balance: Float
    as_of_date: String
    date_of_birth: String
    company_name: String
    name_prefix: String
    first_name: String
    middle_initial: String
    last_name: String
    job_title: String
    phone: String
    work_phone: String
    mobile: String
    fax: String
    email: String
    cc_email: String
    website: String
    other: String
    billed_street: String
    billed_suite: String
    billed_zip: String
    billed_city: String
    billed_state: String
    shipped_street: String
    shipped_suite: String
    shipped_zip: String
    shipped_city: String
    shipped_state: String
    vendor_type_id: Int
    status: String
  }

  type VendorBanks {
    id: ID!
    name: String
  }

  type fetch_Tenant_by_id {
    id: ID!
    indi_corp_type: String!
    first_name: String
    last_name: String
    ssn: String
    corporation_name: String!
    ein: String
    phone: String
    email: String
    id_type: String  
    id_number: String 
    opening_balance: Float
    gender: String
    date_of_birth: String
    monthly_gross_income: Float
    additional_income: Float
    marital_status: String
    ethnicity: String
    street_number: String
    suite_floor: String
    zip_code: String
    city: String
    state: String
    country: String
    mailing_address: String
    notes: String
    status: String
    created_by: Int
    createdAt: Date
  }

  type fetch_Vendor_by_id {
    id: ID
    vendor_name: String
    opening_balance: Float
    as_of_date: String
    date_of_birth: String
    company_name: String
    name_prefix: String
    first_name: String
    middle_initial: String
    last_name: String
    job_title: String
    phone: String
    work_phone: String
    mobile: String
    fax: String
    email: String
    cc_email: String
    website: String
    other: String
    billed_street: String
    billed_suite: String
    billed_zip: String
    billed_city: String
    billed_state: String
    shipped_street: String
    shipped_suite: String
    shipped_zip: String
    shipped_city: String
    shipped_state: String
    vendor_type_id: Int!
    vendor_type: VendorType

    status: String
  }

  type fetch_employee_shift_by_id {
    id: Int
    shift_name: String
    shift_short_code: String
    shift_type: String
    unit_id: Int
    flexible_total_hours: Float
    flexible_half_day_hours: Float
    color: String
    office_start_time: String
    office_end_time: String
    halfday_mark_time: String
    early_clock_in: Int
    late_mark_duration: Int
    clockin_in_day: Int
    office_open_days: String
    is_default: Boolean
    created_by: Int
    created_at: Date
    updated_at: Date
  }

  type fetch_Tenant_Contacts_by_id {
    id: ID!
    tenant_id: Int
    is_name_show: Boolean
    first_name: String
    last_name: String
    ssn: String
    phone: String
    email: String
    id_type: String
    id_number: String
    gender: String
    date_of_birth: String
    monthly_gross_income: Float
    additional_income: Float
    marital_status: String
    ethnicity: String
    createdAt: Date
  }

  type fetch_Tenant_Occupancy_by_id {
    id: ID!
    tenant_id: Int
    property_id: Int
    rent_amount: Float
    deposit_amount: Float
    start_date: String
    end_date: String
    next_incr_date: String
    payment_frequency: String
    next_agree_amount_type: String
    next_agree_amount: Float
    terms_condition: String
    createdAt: Date
    property: Property  
  }

  type fetch_all_Tenant_Occupancy {
    id: ID!
    tenant_id: Int
    property_id: Int
    rent_amount: Float
    deposit_amount: Float
    start_date: String
    end_date: String
    next_incr_date: String
    payment_frequency: String
    next_agree_amount_type: String
    next_agree_amount: Float
    terms_condition: String
    createdAt: Date
    property: Property
    tenant: Tenant
  }

  type EmployeeShift {
    id: Int
    shift_name: String
    shift_short_code: String
    shift_type: String
    unit_id: Int
    flexible_total_hours: Float
    flexible_half_day_hours: Float
    color: String
    office_start_time: String
    office_end_time: String
    halfday_mark_time: String
    early_clock_in: Int
    late_mark_duration: Int
    clockin_in_day: Int
    office_open_days: String
    is_default: Boolean
    created_by: Int
    created_at: Date
    updated_at: Date
  }

  type FetchRoster {
    id: ID!
    date: String!
    remarks: String
    send_email: Int
    is_strict: Int
    location: String
    employee: [EmployeeForRoster!]!
    employee_shift: [EmployeeShiftForRoster!]!
  }

  type FetchAttendance {
    id: ID!
    unit_id: Int
    employee_id: Int
    date: String
    status: String
    clock_in_time: String
    clock_out_time: String
    working_from: String
    late: Boolean
    half_day: Boolean
    overwrite_attendance: Boolean
    added_by: Int
    created_at: String
    updated_at: String
  } 

  type FetchEmpployeeAttendance {
    id: ID!
    unit_id: Int
    employee_id: Int
    date: String
    status: String
    clock_in_time: String
    clock_out_time: String
    working_from: String
    late: Boolean
    half_day: Boolean
    overwrite_attendance: Boolean
    added_by: Int
    created_at: String
    updated_at: String
  } 

  type FetchProjects {
    id: ID! 
    title: String!
    estimated_hours: Int 
    priority: String
    start_date: String
    end_date: String 
    summary: String
    team: [Employee!]!
    description: String
  }
    
  type TeamEmployee {
    id: ID!
    firstname: String!
    lastname: String
    social_security_num: String
    phone: String
  }

  type TaskProject {
    id: ID
    title: String
  }

   type FetchTasks {
    id: ID!
    title: String!
    estimated_hours: Int
    category: String
    project: TaskProject       
    start_date: String
    end_date: String
    status: String
    team: [TeamEmployee!]!
    description: String
  }

  type getEmployeeTaskResponse { 
    id: ID!
    unit_id: Int!
    title: String!
    estimated_hours: Int!
    category: String!
    project: TaskProject   
    start_date: String!
    end_date: String!
    status: String
    description: String!
    team: [TeamEmployee!]!
    created_by: Int!
    createdAt: String
    updatedAt: String
  }

  type getEmployeeTimeSheetResponse {
    employee: TimeSheetUser!
    start_time: String!
    end_time: String
    total_time: String
    memo: String
  }

  type TimeSheetUser {
    id: ID!
    name: String!
  }

  type getEmpTaskResForApp { 
    id: ID!
    unit_id: Int!
    title: String!
    estimated_hours: Int!
    category: String!
    project: TaskProject   
    start_date: String!
    end_date: String!
    status: String
    description: String!
    team: [TeamEmployeeApp!]!
    created_by: Int!
    createdAt: String
    updatedAt: String
  }

  type TeamEmployeeApp {
    id: ID!
    firstname: String!
    lastname: String
    social_security_num: String
    phone: String
  }

  type TaskProjectApp {
    id: ID
    title: String
    team: [TeamEmployeeApp!]!
  }

  type TaskAssignApp {
    id: ID!
    task_id: Int
    title: String!
    description: String
    start_date: String
    end_date: String
    estimated_hours: Int
    status: String
    employee: TeamEmployeeApp!
  }

  type FetchTasksForApp {
    id: Int!
    project_id: Int!
    project: TaskProjectApp
    assigns: [TaskAssignApp!]!
  }


  type TaskEmployee {
    id: ID!
    firstname: String!
    lastname: String
    social_security_num: String
    phone: String
  }

  type FetchUserActivity {
    id: ID!
    activity_type: String!
    activity_time: String
    details: String
    status: String      
    ip_address: String
    user_agent: String
    user : ActivityFetchUser
  }

  type SignDocsResponse {
    id: Int
    document_title: String
    document_type: String
    upload_docs: String
    must_be_signed: Boolean
    path: String
    notes: String
    status: Boolean
  }

  type ActivityFetchUser {
    user_id: ID
    name: String
    email: String
  }
  
  type FetchClients {
    id: ID!
    first_name: String!
    last_name: String
    email: String
    phone: String
    ssn: String
    city: String
    state: String
    country: String
    status: String
  }

  type FetchClientEntity {
    id: ID!
    client_id: ID!
    entity_name: String!
    entity_ein: String!
    email: String
    service_id: String
    phone: String
    street_number: String
    suite_floor: String
    zip_code: String
    city: String
    state: String
    country: String
  }

  type FetchClientService {
    id: ID!
    code: String!
    name: String!
    price: String
    status: String
    description: String
  }

  type ShiftRoster {
    id: ID!
    employee: [Employee!]!
    employee_shift: [EmployeeShift!]!
    date: String!
    holiday: Boolean
    remarks: String
  }

  type RosterEmployee {
    id: ID!
    firstname: String!
    lastname: String!
    social_security_num: String
  }

  type EmployeeShiftForAttendance {
    id: ID!
    shift_name: String!
    shift_type: String
    office_start_time: String
    office_end_time: String
    flexible_total_hours: Float
    color: String
  }

  type EmployeeAttendance {
    id: ID!
    employee_id: ID!
    date: String!
    status: String
    clock_in_time: String
    clock_out_time: String
    working_from: String
    late: Boolean
    half_day: Boolean
    overwrite_attendance: Boolean
  }

  type AttendanceByRoster {
    id: ID!
    employee: [RosterEmployee!]!
    employee_shift: [EmployeeShiftForAttendance!]!
    date: String!
    holiday: Boolean
    remarks: String
    attendance: EmployeeAttendance
  }

  type fetch_Roster_Byid {
    id: ID!
    date: String!
    remarks: String
    send_email: Int
    is_strict: Int
    location: String
    employee: [EmployeeForRoster!]!
    employee_shift: [EmployeeShiftForRoster!]!
  }

  type EmployeeForRoster {
    id: ID!
    firstname: String!
    lastname: String!
    social_security_num: String
  }

  type EmployeeShiftForRoster {
    id: Int!
    shift_name: String!
    shift_type: String!
    color: String
    office_start_time: String
    office_end_time: String
    flexible_total_hours: String
    flexible_half_day_hours: String
  }

  type fetch_Tenant_Documents_by_id {
    id: ID!
    name: String!
    description: String
    file: String
  }

  type SubTaskEmp {
    id: ID!
    firstname: String
    lastname: String
  }

  type SubTaskUser {
    id: ID!
    name: String
  }

  type SubTask {
  id: ID!
  title: String!
  start_date: String
  due_date: String
  description: String
  status: String
  task_id: Int!
  assigned_to: Int
  assigned_by: Int

  assignedTo: SubTaskEmp
  assignedBy: SubTaskUser

  created_by: Int
  created_at: String
  updated_at: String
}


  type UserAuthor {
    id: ID!
    name: String
  }

  type TaskComment {
    id: ID!
    task_id: Int!
    comment: String!
    created_at: String
    author: UserAuthor
     likes: Int
    dislikes: Int
  }
  type TaskNotes {
    id: ID!
    task_id: Int!
    notes: String!
    created_at: String
    author: UserAuthor
  }

  input ContactsUpdateInput {
    id: Int
    is_name_show: Boolean
    first_name: String
    last_name: String
    ssn: String
    phone: String
    email: String
    id_type: String
    id_number: String
    gender: String
    date_of_birth: String
    monthly_gross_income: Float
    additional_income: Float
    marital_status: String
    ethnicity: String
  }



  input OccupancyUpdateInput {
    id: Int!
    tenant_id: Int
    property_id: Int
    rent_amount: Float
    deposit_amount: Float
    start_date: String
    end_date: String
    payment_frequency: String
    next_agree_amount: Float
    next_agree_amount_type: String
    next_incr_date: String
    terms_condition: String
    items: [AgreementItemInput]   # ✅ Add this
  }
    
  input TenantUpdateInput {
    id: ID!
    indi_corp_type: String!
    first_name: String
    last_name: String
    ssn: String
    corporation_name: String!
    ein: String
    phone: String
    email: String
    id_type: String  
    id_number: String 
    opening_balance: Float
    gender: String
    date_of_birth: String
    monthly_gross_income: Float
    additional_income: Float
    marital_status: String
    ethnicity: String
    street_number: String
    suite_floor: String
    zip_code: String
    city: String
    state: String
    country: String
    mailing_address: String
    notes: String
    status: String
  }

  input AgreementItemInput {
    included_excluded_status: Int
    name: String
    amount: Float
    item_number: String
    item_type: String
    appliance_brand: String
    appliance_model: String
    warranty_start_date: String
    warranty_end_date: String
    appliance_description: String
    utility_provider_name: String
    utility_description: String
    other_description: String
  }

  input RentalcontractInput {
    id: Int  
    property_id: Int!
    unit_id: Int
    tenant_id: Int!
    rent_amount: Float!
    deposit_amount: Float!
    start_date: String!
    end_date: String!
    next_incr_date: String
    next_agree_amount_type: String
    next_agree_amount: Float
    payment_frequency: String!
    Attachment: Upload
    terms_condition: String
    items: [AgreementItemInput]
  }

  input PropertyOwnerInput {
    id: Int
    property_id: Int       
    unit_id: Int       
    first_name: String!
    last_name: String!
    ssn: String!
    phone_no: String!
    email: String!
    company: String!
    street_number: String!
    gender: String
    suite_floor: String
    zip_code: String
    city: String
    state: String
    country: String
    main_image: String
    status: String
    unit_id: Int
    ownership_type: String
  }

  type Attendance {
    id: Int!
    unit_id: Int
    employee_id: Int
    date: String
    status: String
    clock_in_time: String
    clock_out_time: String
    working_from: String
    late: Boolean
    half_day: Boolean
    overwrite_attendance: Boolean
    added_by: Int
    created_at: String
    updated_at: String
  }

  type singleAttendanceResponse {
    id: Int
    unit_id: Int
    employee_id: Int
    date: String
    status: String
    clock_in_time: String
    clock_out_time: String
    working_from: String
    late: Boolean
    half_day: Boolean
    overwrite_attendance: Boolean
    added_by: Int
    created_at: String
    updated_at: String
    success: Boolean!
    message: String
  }
  
  input AttendanceInput {
    id: Int
    unit_id: Int
    employee_ids: [Int!]!
    date: String
    dates: [String]   # <--- NEW for month marking
    status: String
    clock_in_time: String
    clock_out_time: String
    working_from: String
    late: Boolean
    half_day: Boolean
    overwrite_attendance: Boolean
  }

  input AttendanceInputSingle {
    id: Int
    unit_id: Int
    employee_id: Int
    date: String
    status: String
    clock_in_time: String
    clock_out_time: String
    working_from: String
    late: Boolean
    half_day: Boolean
  }

  input LeaveInput {
    id: Int
    employee_id: Int!
    leave_type: String!
    department: String!
    designation: String!
    employee_type: String!
    status: String!
    duration: String!
    date: String
    unit_id: Int!
    date_range: [String]
    reason: String!
    file: Upload
  }

  input Emp_leaveInput {
    id: Int
    employee_id: Int!
    duration: String!
    date: String
    date_range: [String]
    reason: String!
    unit_id: Int!
  }

  input Emp_leaveUpdateInput {
    id: Int
    employee_id: Int!
    duration: String!
    date: String
    date_range: [String]
    reason: String!
    unit_id: Int!
  }

  input empLeaveUpdateInput {
    id: Int
    employee_id: Int!
    duration: String!
    date: String
    date_range: [String]
    reason: String!
    unit_id: Int!
  }


  input LeaveStatusUpdateInput {
    id: Int!
    status: String!
    unit_id: Int
  }



   input LeaveUpdateInput {
    id: Int
    employee_id: Int!
    leave_type: String!
    department: String!
    designation: String!
    employee_type: String!
    status: String!
    duration: String!
    date: String
    unit_id: Int!
    date_range: [String]
    reason: String!
    file: Upload
  }

  input ProjectInput {
    title: String!
    estimated_hours: Int!
    priority: String!
    start_date: String!
    end_date: String!
    summary: String!
    team: [String] 
    description: String!
    unit_id: Int!

  }

  input ProjectUpdateInput {
    id: ID!
    title: String!
    estimated_hours: Int!
    priority: String!
    start_date: String!
    end_date: String!
    summary: String!
    team: [String] 
    description: String!
    unit_id: Int!

  }

  input TaskUpdateInput {
    id: ID!
    title: String!
    estimated_hours: Int!
    category: String!
    project: String!
    start_date: String!
    end_date: String!
    status: String
    team: [String]
    description: String!
    unit_id: Int!
  }

input TaskInput {
  title: String!
  estimated_hours: Int!
  category: String!
  project: String!
  start_date: String!
  end_date: String!
  status: String
  team: [String]
  description: String!
  unit_id: Int!
}

  input ConsentInput {
    unit_id: Int!
    document_title: String
    document_type: String
    uploaded_document: String
    mustBeSigned: String 
    notes: String
  }
  
  input ConsentUpdateInput {
    id: ID!
    document_title: String
    document_type: String
    uploaded_document: String
    mustBeSigned: String 
    notes: String
  }

  input MarkUpdatestatusInput {
    id: ID!
    status: Int! 
    message: String
  }

  input LogActivityInput {
    user_id: Int
    activity_type: String
    activity_time: String
    details: String
    status: String
    ip_address: String
    user_agent: String
    source: String
  }

  input LeaveTypeEntitlementInput {
    effective_after: Int
    allowed_probation: Boolean
    unused_leave: String
    over_utilization: String
    allowed_notice: Boolean
  }

  input Task_history_input {
    unit_id: Int!
    task_id: Int!
    sub_task_id: Int
    user_id: Int!
    details: String
    created_by: Int!
  }

input LeaveTypeApplicabilityInput {
  gender: [String]
  marital_status: [String]
  department: [String]
  designation: [String]
  user_role: [String]
}

input LeaveTypeInput {
  type_name: String!
  leavetype: String!
  no_of_leaves: String!
  paid_status: String!
  monthly_limit: Int!
  color: String!
  unit_id: Int!
  entitlement: LeaveTypeEntitlementInput!
  applicability: LeaveTypeApplicabilityInput!
}

input DesignationInput {
  name: String!
  parent: ID
  unit_id: Int!
}

input DepartmentInput {
  name: String!
  parent: ID
  unit_id: Int!
}

input HolidayInput {
  repeats: [HolidayRepeatInput!]!
  department: [String!]
  designation: [String!]
  employee_type: [String!]
  unit_id: Int
}

input HolidayRepeatInput {
  date: String!
  occasion: String!
}

input HolidayUpdateInput {
    id: ID!
    repeats: [HolidayUpdateRepeatInput!]!
    department: [String!]!
    designation: [String!]!
    employee_type: [String!]!
    unit_id: Int
}

input ClientUpdateInput {
    id: ID!
    first_name: String
    last_name: String
    ssn: String
    id_type: String
    id_number: String
    phone: String
    email: String
    gender: String
    date_of_birth: String
    opening_balance: Float
    monthly_gross_income: Float
    additional_income: Float
    marital_status: String
    ethnicity: String
    corporation_name: String
    ein: String
    street_number: String
    suite_floor: String
    zip_code: String
    city: String
    state: String
    country: String
    mailing_address: String
    notes: String
    unit_id: Int

}


input HolidayUpdateRepeatInput {
    date: String!
    occasion: String!
}
 
input SignUpInput {
  email: String!
  password: String!
}

input RegisterWithMobileInput {
  email: String!
  password: String!
  user_pass: String!
  otp: String! 
  device_id: String! 
  device_model: String! 
  device_OS: String!
}


type RegisterWithMobileResponse {
  success: Boolean!
  message: String  
  employee: TemporaryEmployee 
}

type empLeaveUpdateResponse {
  success: Boolean!
  message: String  
}

input CompleteRegistrationInput { 
  id: String!
  first_name: String!
  middle_name: String
  last_name: String!
  email: String!
  ssn: String
  phone_number: String!
  emergency_phone_number: String
  number_and_street: String!
  suite_floor: String
  zip_code: String!
  city: String!
  state: String!
  country: String!
  gender: String
  id_type: String
  id_number: String
  face_embedding: String
}
  
type CompleteRegistrationResponse {
  success: Boolean!
}

input FaceLoginInput { 
  device_id: String!
}
   
input LoginWithEmailInput {
  email: String!
  password: String!
}


input LogoutInput {
  employee_id: String!
  user_id: String!
  session_id: String!
  logout_time: String!
  ip_address: String!
  user_agent: String!
}

input checkInWithFaceInput {
  employee_id: String!
  timestamp: String!
  location: String!
}

input checkOutWithFaceInput{
  employee_id: String!
  timestamp: String!
  location: String!
}

input checkInInput {
  employee_id: Int 
  user_id: Int
  date: String
  clock_in_time: String
  location: String!
}

input checkOutInput {
  employee_id: Int
  user_id: Int
  date: String
  clock_out_time: String
}

type FaceLoginResponse {
  success: Boolean!
  message: String
  users: [LoginEmailUserByFace]
}

type LoginEmailUserByFace {
  user_id: ID!
  unit_id: Int
  employee_id: ID!
  name: String
  email: String
  password: String
  login_count: Int
  status: String
  face_embedding: String
}
 
type checkInWithFaceResponse {
  success: Boolean!
  message: String
}

type checkInResponse {
  success: Boolean!
  message: String
}

type checkOutResponse {
  success: Boolean!
  message: String
}

type checkOutWithFaceResponse {
  success: Boolean!
  message: String
}


type EmpleaveResponse {
  success: Boolean!
  message: String
}


type LoginWithEmailResponse {
  success: Boolean!
  message: String
  user: LoginEmailUser
  token: String
  refreshToken: String
  expiresIn: String
  refreshExpiresIn: String
}

type VerifyTokenResponse {
  success: Boolean!
  message: String
  data: TokenData
}

type RefreshTokenResponse {
  success: Boolean!
  message: String
  token: String
  expiresIn: String
}

type TokenData {
  userId: ID
  email: String
  employeeId: ID
}
  

type LogoutResponse {
  success: Boolean!
  message: String
}

type LoginEmailUser {
  user_id: ID!
  unit_id: Int
  employee_id: ID!
  name: String
  email: String
  password: String
  login_count: Int
  status: String
  face_embedding: String
}

type TemporaryEmployee {
  id: ID!
  email: String!
}

type mobileUser {
  id: ID!
  email: String!
  token: String
}

type Holiday {
  id: ID!
  date: String!
  occasion: String
  department: [String]
  designation: [String]
  employee_type: [String]
  unit_id: Int
}

  type ChartAccountType {
    id: ID!
    title: String!
    unit_id: String
    status: String
  }

  type ChartAccounts {
    id: ID!
    type_id: String
    account: String
    description: String
    sub_account_of: String
    account_no: String
    routing_no: String
    check_no: String
    opening_balance: String
    tax_line_map: String
    note: String
    unit_id: Int 
  }

  type UserForHistory {
    name: String
  }
 
  type TaskHistory {
    id: ID!
    unit_id: Int
    task_id: Int
    sub_task_id: Int
    user_id: Int
    details: String
    created_by: Int
    created_at: String
    employee: UserForHistory
  }


  type CheckItem {
    account_id: Int
    memo: String
    amount: Float
  }
  
  type CheckVendor {
    id: ID!
    vendor_name: String
    email: String
    billed_street: String
    billed_suite: String
    billed_zip: String
    billed_city: String
    billed_state: String
  } 
  
  type CheckBank {
    id: ID!
    name: String
    account_name: String
    routing_no: String
    account_no: String
    street_no: String
    city: String
    state: String
    zip_code: String
  }

  type Checks {
    id: ID!
    vendor_id: Int
    bank_id: Int
    available_balance: Float
    street: String
    suit: String
    zip: String
    city: String
    state: String
    check_no: String
    total_amount: Float
    payment_date: String
    invoice_number: String
    remaining_balance: Float
    send_email: Boolean
    print_check: Boolean
    unit_id: Int
    items: [CheckItem]
    vendor: CheckVendor
    bank: CheckBank
  }

  type Invitations {
    id: ID!
    email: String
    message: String
    invite_link: String
    otp_code: String
    created_at: String
  }

  type PropertyOwner {
    id: Int
    first_name: String!
    last_name: String!
    ssn: String!
    phone_no: String
    email: String!
    company: String
    street_number: String
    gender: String
    suite_floor: String
    zip_code: String
    city: String
    state: String
    country: String
    main_image: String
    status: String!
    created_by: Int
    createdAt: Date
  }

  type LeaveType {
    id: Int
    type_name: String!
    no_of_leaves: String!
  }

  type LeaveEmployee {
    id: ID!
    firstname: String!
    lastname: String!
  }

  type getemployeeleave {
    id: Int
    employee_id: Int
    employee: LeaveEmployee
    leaveType: LeaveType
    leave_type: String
    department: String
    designation: String
    employee_type: String
    status: String!
    duration: String!
    date: String
    date_range: [String]
    reason: String!
    unit_id: Int
    file: String
    created_at: String
  }

  type getemployeeleaveApp {
    id: Int
    employee_id: Int
    employee: LeaveEmployee
    status: String!
    duration: String!
    date: String
    date_range: [String]
    reason: String!
    created_at: String
    created_by: Int

  }
  
  type Leave {
    id: Int!
    employee_id: Int!
    employee: LeaveEmployee
    leaveType: LeaveType   
    leave_type: String
    department: String
    designation: String
    employee_type: String
    status: String!
    duration: String!
    date: String
    date_range: [String]
    reason: String!
    unit_id: Int!
    file: String
    created_at: String
  }

  type Designations {
    id: Int
    title: String!
    status: String!
  }

  type GetExpenseType {
    id: Int
    type_name: String!
    type_date: String!
  }

  type GetExpense {
    id: Int
    expense_name: String
    expense_type_id: Int
    description: String
    expense_amount: Float
    expense_date: String
    status: String
    expense_type: [GetExpenseType!]!
  }
    
  type GetConsents {
    id: Int
    document_title: String
    document_type: String
    uploaded_document: String
    mustBeSigned: Boolean
    notes: String
    unit_id: Int
  }

  type Departments {
    id: Int
    name: String!
    parent: Int
  }

  input OwnerUpdateInput {
    id: ID
    first_name: String!
    last_name: String!
    ssn: String!
    phone_no: String
    email: String!
    company: String
    street_number: String
    gender: String
    suite_floor: String
    zip_code: String
    city: String
    state: String
    country: String
    main_image: String
    status: String!
  }
  
  input BankUpdateInput {
    id: ID!
    name: String!
    account_name: String!
    account_no: String!
    status: String!
    routing_no: String
    check_no: String
    opening_balance: Float
    street_no: String
    city: String
    state: String
    zip_code: String
    description: String
    unit_id: Int
  }

  type TenantForInvoice {
    id: ID
    indi_corp_type: String
    first_name: String
    last_name: String
    corporation_name: String
  }

  type ClientForInvoice {
    id: ID
    first_name: String
    last_name: String
    ssn: String
  }

  type InvoiceItem {
    id: ID
    name: String
    amount: Float
    code: String
  }

  union InvoiceEntity = TenantForInvoice | ClientForInvoice

  type Invoices {
    id: ID!
    tenant_id: ID
    client_id: ID
    invoice_no: String!
    issue_date: String!
    due_date: String!
    items: [InvoiceItem!]!
    note: String
    subtotal: Float
    discount_type: String
    discount: Float
    total: Float
    send_email: Boolean
    print_invoice: Boolean
    print_fax: Boolean
    entity: InvoiceEntity
  }

  type Invoicenumber {
    invoice_number: String!
  }

  type ClientMemorizedInvoices {
    id: ID
    invoice_pay_month: String!
    status: Boolean
    recurring_invoice: InvoiceForMemorizedClient
  }

  type InvoiceForMemorizedClient {
    issue_date: String!
    frequency: String!
    next_date: String
    due_date: String!
    note: String
    subtotal: Float
    discount: Float
    discount_type: String
    total: Float
    entity: ClientForMemorizedInvoice
    items: [MemorizedInvoiceItem!]!
  }

  type ClientForMemorizedInvoice {
    id: Int
    first_name: String
    last_name: String
    ssn: String
    phone: String
    email: String 
  }

  type MemorizedInvoices {
    id: ID
    invoice_pay_month: String!
    status: Boolean
    recurring_invoice: InvoiceForMemorizedTenant
  }

  type InvoiceForMemorizedTenant {
    issue_date: String!
    frequency: String!
    next_date: String
    due_date: String!
    note: String
    subtotal: Float
    discount: Float
    discount_type: String
    total: Float
    entity: memorizedInvoiceEntity
    items: [MemorizedInvoiceItem!]!
  }

  union memorizedInvoiceEntity = TenantForMemorizedInvoice | ClientForMemorizedInvoice

  type TenantForMemorizedInvoice {
    id: Int
    indi_corp_type: String
    first_name: String
    last_name: String
    corporation_name: String
    street_number: String
    phone: String
    email: String
  }

  

  type MemorizedInvoiceItem {
    id: ID!
    title: String!
    amount: Float!
    code: String
  }

   type fetch_invoice_by_Client_id {
    id: ID
    invoice_no: String
    subtotal: Float
    discount: Float
    total: Float
    paid_amount: Float
    balance: Float
    status: String
    type: String
    unit_id: ID

    items: [InvoiceItem]
    entity: InvoiceEntity

    created_at: String
    updated_at: String
  }

  type fetch_invoice_by_Tenant_id {
    id: ID
    invoice_no: String
    subtotal: Float
    discount: Float
    total: Float
    paid_amount: Float
    balance: Float
    status: String
    type: String
    unit_id: ID

    items: [InvoiceItem]
    entity: InvoiceEntity

    created_at: String
    updated_at: String
  }

    
  type RecurringInvoices {
    id: ID!
    tenant_id: ID
    client_id: ID
    invoice_no: String!
    issue_date: String!
    frequency: String!
    due_date: String!
    next_date: String!
    items: [RecurringInvoiceItem!]!
    note: String
    subtotal: Float
    discount_type: String
    discount: Float
    total: Float
    send_email: Boolean
    print_invoice: Boolean
    print_fax: Boolean
    entity: RecurringInvoiceEntity
  }

  union RecurringInvoiceEntity = TenantForRecurringInvoice | ClientForRecurringInvoice

  type TenantForRecurringInvoice {
    id: ID
    indi_corp_type: String
    first_name: String
    last_name: String
    corporation_name: String
  }

  type ClientForRecurringInvoice {
    id: ID
    first_name: String
    last_name: String
    ssn: String
  }

  type RecurringInvoiceItem {
    id: ID
    name: String
    amount: Float
    code: String
  }

  input UpdateRecurringInvoiceInput {
    id: Int
    frequency: String!
    next_date: String!
  }

  type AttendanceLog {
    id: ID!
    date: String!
    clock_in_time: String!
    clock_out_time: String
    status: String!
    location: String
    late: Boolean
    half_day: Boolean
  }
  
  type todayAttendanceResponse {
    id: ID! 
    date: String!
    clock_in_time: String!
    clock_out_time: String
    status: String!
    location: String!
  }
  
  type EmployeeIdResult {
    employee_id: ID!
  }

  type UnitIdResult {
    unitId: ID!
  }

  type getEmployeeByIDResponse {
    id: ID!
    firstname: String
    middlename: String
    lastname: String
    address: String
    city: String
    state: String
    zip: String
    country: String
    phone: String
    emergency_phone_number: String
    gender: String
    social_security_num: String
    id_type: String
    id_number: String
    status: String
  }

  type Query {
    verifyUserToken(token: String!): VerifyTokenResponse!
    weekly_dates(year: Int, unit_id: Int): [Period]
    me: LoginUser
    isLogin: Boolean!
    bank(bank_id: Int): Bank
    banks(unit_id: Int): [Bank]

    total_cash_in_hand(unit_id: Int, date: Date): Float
    employee_payroll(employee_payroll_id: Int): EmployeePayroll
    employee_payrolls(offset: Int, first: Int, filter: String): [EmployeePayroll]
    employee(employee_id: Int): Employee
    employee_payroll_history(employee_id: Int): [EmployeePayrollHistory]
    employees_for_unit(unit_id: Int, filter: String): [Employee]
    employee_detail(employee_id: Int): Employee
    expense(expense_id: Int): Expense
    expenses: [Expense]
    franchise(franchise_id: Int): Franchise
    franchises: [Franchise]
    job_titles: [JobTitle]
    payroll(payroll_id: Int): Payroll
    payrolls(offset: Int, first: Int, filter: String): [Payroll]
    payroll_summary(year: Int, unit_id: Int): [PayrollSummary]
    payroll_summary2(year: Int, unit_id: Int): [PayrollSummary]
    payroll_summary3(year: Int, unit_id: Int): [PayrollSummary]
    employee_payrolls_by_payroll_id(payroll_id: Int): [EmployeePayroll]
    employee_payrolls_aggregated(payroll_ids: [Int]): [EmployeePayroll]
    employee_changes(unit_id: Int): [EmployeeChange]
    
    unit_payrolls(unit_id: Int): [PayrollSummary]
 
    user(user_id: Int): User
    users: [User]
    user_groups: [UserGroup]
    user_units(user_id: Int): [Unit]
    user_dashboard(user_id: Int): UserDashboard
    user_dashboard2(user_id: Int): UserDashboard3
    user_summary(user_id: Int, from: Date, to: Date): UserSummary
    user_summary_by_month(user_id: Int, from: Date, to: Date): [UserSummary]

    unit(unit_id: Int): Unit
    units(offset: Int, first: Int, filter: String): [Unit]
    sale(sale_id: Int): Sale
    sales(offset: Int, first: Int, filter: SaleInput): [Sale]

    sales_food_delivery(delivery_id: Int): Delivery
    sales_food_deliveries(sale_id: Int): [Delivery]

    sales_details(unit_id: Int, month: Int, year: Int): [Sale]
    sales_weekly(unit_id: Int, year: Int): [SaleAggregated]
    sales_weekly2(unit_id: Int, year: Int): [SaleAggregated]
    sales_weekly3(unit_id: Int, year: Int): [SaleAggregated]
    sales_monthly(unit_id: Int, year: Int): [SaleAggregated]
    sales_monthly2(unit_id: Int, year: Int): [SaleAggregated]

    sale_comparison(unit_id: Int, period: PeriodType, year1: Int, month1: Int, year2: Int, month2: Int): [NetSales]
    sales_expense(expense_id: Int): SaleExpense
    sales_expenses(sale_id: Int): [SaleExpense]
    sales_years: [Int]

    supplier(supplier_id: Int): Supplier
    suppliers: [Supplier]

    expense_report(unit_id: Int, from: String, to: String): ExpenseReport
    sales_report(unit_id: Int, from: String, to: String): SalesReport

    user_missing_sales(user_id: Int): [MissingSales]
    user_missing_payrolls(user_id: Int): [MissingPayroll]

    user_unit_summaries(user_id: Int, from: String, to: String): [UnitSummary]
    user_unit_summaries_weekly(user_id: Int, week_of: String): [UnitSummary]

    file_archive_files(unit_id: Int, date: String): [ArchiveFile]
    attendance_for_employee(month: String, year: String): [Attendance]
    get_properties(unit_id: Int): [Property]
    get_payment_transaction(unit_id: Int): [PaymentTransaction]
    get_payment_transaction_client(unit_id: Int): [PaymentTransactionClient]
    
    get_client_payment_transaction(unit_id: Int): [ClientPaymentTransaction]
    get_tenants(unit_id: Int): [Tenant]
    get_invoices(unit_id: Int!, type: String!): [Invoices!]!
    get_invoice_number(unit_id: Int): [Invoicenumber]
    get_memorized_invoices(unit_id: Int, type: String!): [MemorizedInvoices!]!
    get_client_memorized_invoices(unit_id: Int, type: String!): [ClientMemorizedInvoices!]!
    

    get_recurring_invoices(unit_id: Int, type: String!): [RecurringInvoices!]!

    get_property_owner: [PropertyOwner]
    get_leave_type: [LeaveType]
    get_leaves(unit_id: Int): [Leave!]!
    get_leaves_by_employee(employee_id: Int): [getemployeeleave!]!
    get_leaves_by_employee_app(employee_id: Int): [getemployeeleaveApp!]!

    get_designations: [Designations]
    get_departments(unit_id: Int): [Departments!]!

    get_holidays(unit_id: Int): [Holiday!]!
    get_chart_accounts(unit_id: Int): [ChartAccounts!]!
    get_chart_account_type: [ChartAccountType]
    get_checks(unit_id: Int): [Checks!]!

    get_property_by_id(property_id: Int): fetch_Property_by_id
    get_client_by_id(client_id: Int!): fetch_Client_by_id
    get_payment_by_id(id: Int!): ReceiptPayment
    get_tenant_balance_by_id(tenant_id: Int): TenantBalance
    get_client_balance_by_id(client_id: Int): ClientBalance
    get_tenant_by_id(tenant_id: Int!): fetch_Tenant_by_id 
    get_unpaid_invoices(tenant_id: Int ): [fetch_invoice_by_Tenant_id] 

    get_unpaid_client_invoices(client_id: Int): [fetch_invoice_by_Client_id]

    get_tenant_contacts_by_id(tenant_id: Int!): [fetch_Tenant_Contacts_by_id]
    get_tenant_occupancy_by_id(tenant_id: Int!): [fetch_Tenant_Occupancy_by_id]
    get_all_tenant_occupancy: [fetch_all_Tenant_Occupancy]
    get_tenant_document_by_id(tenant_id: Int!): [fetch_Tenant_Documents_by_id]
    get_property_items_by_id(property_id: Int!): [fetch_Property_Items_by_id]
    get_property_taxes_by_id(property_id: Int!): [get_property_taxes_by_id] 
    get_property_docs_by_id(id: Int!): [get_property_documents_by_id] 
    is_tenant_contact_email_exist(email: String!): Boolean
    get_agreement_items_by_contract_id(occupancy_id: Int!): AgreementWithItems
    get_agreement_items_by_tenant_id(tenant_id: Int!): AgreementWithItems
    get_all_employee_shifts(unit_id: Int): [EmployeeShift!]! 
    get_all_employee_shifts_off(unit_id: Int): [EmployeeShift!]!
    get_employee_shift_by_id(employeeShiftId: Int!): fetch_employee_shift_by_id
    get_shift_rosters(unit_id: Int): [FetchRoster!]!

    fetch_roster_by_id(roster_id: Int!): fetch_Roster_Byid
    get_attendance: [FetchAttendance!]!
    get_employee_attendance(employee_id: Int): [FetchEmpployeeAttendance!]!
    get_projects(unit_id: Int): [FetchProjects!]!

    get_tasks(unit_id: Int): [FetchTasks!]!  
    get_employee_tasks(employee_id: Int): [getEmployeeTaskResponse!]!
    get_task_by_id(employee_id: Int!): [getEmpTaskResForApp!]!

    get_clients(unit_id: Int): [FetchClients!]!

    get_client_entity(client_id: Int!): [FetchClientEntity!]!
    get_global_currency(unit_id: Int): [GlobalCurrency!]!  
    get_packages(unit_id: Int): [Package!]! 
    get_temporary_employees(unit_id: Int): [GetTemporaryEmployees!]!
    get_vendorType(unit_id: Int): [VendorType!]! 
    getEmployeeId(user_id: Int!): EmployeeIdResult!
    getUnitId(login_employee_id: Int!): UnitIdResult!
    get_vendors(unit_id: Int): [Vendor!]!
  
    get_vendor_by_id(vendor_id: Int!): fetch_Vendor_by_id
    get_payment_terms: [PaymentTerm!]!
    get_vendor_payment(vendor_id: ID!): VendorPayment
    get_vendor_tax(vendor_id: ID!): VendorTax
    get_invitations(unit_id: Int): [Invitations!]!

    attendanceLogs_by_id(employee_id: Int!): [AttendanceLog!]!
    todayAttendance(employee_id: Int!): todayAttendanceResponse
    get_expense_type: [GetExpenseType]
    get_expenses: [GetExpense]
    get_consents(unit_id: Int!): [GetConsents]
    get_swap_task: [GetSwapTask]
    getEmployeeByIDForApp(employee_id: Int!): getEmployeeByIDResponse
    getUserActivities(user_id: Int!): [FetchUserActivity!]!
    
    get_signDocs(employee_id: Int!): [SignDocsResponse!]!  
    get_services(unit_id: Int!): [FetchClientService!]!
    get_subtasks_by_task(user_id: Int, unit_id: Int, task_id: Int): [SubTask]
    get_task_comments(user_id: Int, unit_id: Int, task_id: Int): [TaskComment]
    get_task_notes(user_id: Int, unit_id: Int, task_id: Int): [TaskNotes] 
    get_time_sheet(user_id: Int, unit_id: Int, task_id: Int): [getEmployeeTimeSheetResponse!]!
    get_task_history(user_id: Int, unit_id: Int, task_id: Int): [TaskHistory!]! 
  }
  
  type Mutation {  
    refresh_token(input: RefreshTokenInput!): RefreshTokenResponse!
    login(email: String!, password: String!): LoginUser
    signup(username: String!, email: String!, password: String!, otp: String!): SignupUserResponse
    logout: Boolean!
    change_user_password(email: String!, oldPassword: String!, newPassword: String!): Boolean!
    employee_delete(employeeId: Int): Boolean!
    employee_entry(employeeInput: EmployeeInput): Boolean!
    employee_change_delete(employeeChangeId: Int): Boolean!
    sales_deposit_entry(depositInput: DepositInput): Boolean!
    sales_deposit_delete(depositInput: DepositInput): Boolean!
    sales_food_delivery_entry(deliveryInput: DeliveryInput): Boolean!
    sales_food_delivery_delete(deliveryInput: DeliveryInput): Boolean!
    sales_expense_entry(expenseInput: ExpenseInput): Boolean!
    sales_expense_delete(expenseInput: ExpenseInput): Boolean!
    sales_entry(saleInput: SaleInput): Boolean!
    sales_set_status(salesId: Int!, status: Int!): Boolean!
    unit_entry(unitInput: UnitInput): Boolean!
    user_entry(userInput: UserInput): Boolean!
    payroll_entry(payrollInput: PayrollInput): Int!
    payroll_set_status(payroll_id: Int!, status: String!): Boolean!
    bank_entry(bankInput: BankInput!): Boolean!
    delete_bank(id: Int!): Boolean!
    expense_entry(expenseEntryInput: ExpenseEntryInput!): Boolean!
    job_title_entry(jobTitleInput: JobTitleInput!): Boolean!
    supplier_entry(supplierInput: SupplierInput!): Boolean! 
    franchise_entry(franchiseInput: FranchiseInput!): Boolean!
    payroll_delete(payroll_id: Int!): Boolean! 
    fix_cash_in_hand(unit_id: Int!): Boolean!
    file_archive_delete(file_id: Int!): Boolean!
    attendance_delete(attendanceId: Int!): Boolean!
    property_entry(propertyInput: PropertyInput!): Int
    save_received_revenue(revenuereceiveInput: RevenueReceivedInput!): Payment
   
    update_property(propertyUpdateInput: PropertyUpdateInput!): Int
    update_property_item(propertyItemUpdateInput: PropertyItemUpdateInput!): Int
    update_property_tex(propertyTaxUpdateInput: PropertyTaxUpdateInput!): Int
    
    property_item_entry(propertyItemInput: PropertyItemInput!): Boolean
    property_tax_entry(propertyTaxInput: PropertyTaxInput!): Boolean
    property_document_entry(propertyDocInput: PropertyDocInput!): Boolean
    bank_delete(id: Int!): Boolean!
    delete_property(id: Int!): Boolean 
    delete_tenant(id: Int!): Boolean
    delete_invoice(id: Int!, type: String): Boolean 
    delete_RecurringInvoice(id: Int!): Boolean
    delete_Holiday(id: Int!): Boolean
    delete_leave(id: Int!): Boolean
    delete_leave_app(id: Int!): deleteleaveResponse
    delete_Department(id: Int!): Boolean
    delete_Designations(id: Int!): Boolean
    delete_owner(id: Int!): Boolean
    delete_project(id: Int!): Boolean
    delete_task(id: Int!): Boolean 
    delete_subtask(id: Int!): Boolean
    delete_client(id: Int!): Boolean
    delete_client_service(id: Int!): Boolean
    delete_client_entity(id: Int!): Boolean 
    delete_property_docs(id: Int!): Boolean
    delete_property_tax(id: Int!): Boolean
    delete_tenant_contact(id: Int!): Boolean 
    delete_tenant_occupancy(id: Int!): Boolean
    delete_property_items(id: Int!): Boolean
    delete_property_taxes(id: Int!): Boolean
    delete_employee_shift(id: Int): Boolean!
    delete_ChartAccount(id: Int): Boolean!
    delete_consent(id: Int): Boolean!
    delete_task_swaps(id: Int): Boolean!
    delete_service(id: Int): Boolean!
    tenant_entry(tenantInput: TenantInput!): Int

    invoice_entry(invoiceInput: InvoiceInput!): forPrintInvoices 
    client_invoice_entry(invoiceInput: InvoiceInput!): forPrintInvoices 

    invoice_entry_from_memorized(invoiceInputFromMemorized: InvoiceInputFromMemorized!): Boolean
    bulk_invoice_entry_from_memorized(bulkInvoiceFromMemorizedInput: BulkInvoiceFromMemorizedInput!): Boolean
    create_memorized_invoice(memorizedInput: MemorizedInput!): Int
    update_invoice(invoiceUpdateInput: InvoiceUpdateInput!): Int 
    update_designation(designationUpdateInput: DesignationUpdateInput!): Int 
    update_department(departmentUpdateInput: DepartmentUpdateInput!): Int 
    update_recurringInvoice(updateRecurringInvoiceInput: UpdateRecurringInvoiceInput!): Int  
    contact_entry(contactInput: ContactInput!): Boolean  
    update_tenant_contacts(contactsUpdateInput: ContactsUpdateInput!): Int 
    update_tenant_occupancy(occupancyUpdateInput: OccupancyUpdateInput!): Occupancy
    update_tenant(tenantUpdateInput: TenantUpdateInput!): Int 
    update_owner(ownerUpdateInput: OwnerUpdateInput!): Int
    update_bank(bankUpdateInput: BankUpdateInput!): Int
    occupancy_entry(occupancyInput: OccupancyInput!): Occupancy
    rentalcontract_entry(rentalcontractInput: RentalcontractInput!): Boolean
    
    property_owner_entry(owners: [PropertyOwnerInput!]!): [Int!]! 
    
    save_attendance(attendanceInput: AttendanceInput!): [Attendance!]!
    save_attendance_single_entry(attendanceInputSingle: AttendanceInputSingle!): [singleAttendanceResponse!]!
    save_leave(leaveInput: LeaveInput!): Boolean  
    save_leave_by_employee(emp_leaveInput: Emp_leaveInput!): Boolean  
    save_leave_by_emp_app(emp_leaveInput: Emp_leaveInput!): EmpleaveResponse  
    save_project(projectInput: ProjectInput!): Boolean

    save_task(taskInput: TaskInput!): Boolean
    update_task(taskUpdateInput: TaskUpdateInput!): Int 

    save_consent(consentInput: ConsentInput!): Int
    update_consent(consentUpdateInput: ConsentUpdateInput!): Int
    markUpdateStatus(markUpdatestatusInput: MarkUpdatestatusInput!): Boolean  

    logUserActivity(input: LogActivityInput!): ActivitylogResponse

    update_project(projectUpdateInput: ProjectUpdateInput!): Int 
    
    save_leave_type(leaveTypeInput: LeaveTypeInput!): Boolean
    save_holiday(holidayInput: HolidayInput!): Boolean   
    
    save_designation(designationInput: DesignationInput!): Boolean
    save_department(departmentInput: DepartmentInput!): Boolean
    make_invoice_recurring_entry(recurringInvoiceInput: RecurringInvoiceInput!): Int
    create_employee_shift(employeeShiftInput: EmployeeShiftInput!): Boolean
    update_employee_shift(employeeShiftInput: EmployeeShiftInput!): Int
    set_default_shift(id: Int!): Boolean!
    save_shift_roster(rosterInput: ShiftRosterInput!): Boolean 
    save_shift_roster_single(rosterInputSingle: ShiftRosterInputSingle!): Boolean
    save_invitation(invitationInput: InvitationInput!): Boolean

    global_currency_entry(currencyInput: CurrencyInput!): Boolean
    update_global_currency(currencyUpdateInput: CurrencyUpdateInput!): Boolean
    delete_global_currency(id: Int!): Boolean

    update_shift_roster(rosterupdateInput: RosterupdateInput!): Boolean 
    update_holiday(holidayUpdateInput: HolidayUpdateInput!): Int
    update_leave(leaveUpdateInput: LeaveUpdateInput!): Int
    update_leave_by_employee_id(emp_leaveUpdateInput: Emp_leaveUpdateInput!): Int
    update_leave_by_employee_id_app(empLeaveUpdate: empLeaveUpdateInput!): empLeaveUpdateResponse
    update_leave_status(updateLeaveStatusInput: LeaveStatusUpdateInput!): Boolean
    
    signUpUser(input: SignUpInput!) : mobileUser
    registerWithMobile(input: RegisterWithMobileInput!): RegisterWithMobileResponse! 
    completeRegistration(input: CompleteRegistrationInput!): CompleteRegistrationResponse!
    
    loginWithFace(input: FaceLoginInput!): FaceLoginResponse!
    loginWithEmail(input: LoginWithEmailInput!): LoginWithEmailResponse!
    logoutByApp(input: LogoutInput!): LogoutResponse!
    checkInWithFace(input: checkInWithFaceInput!): checkInWithFaceResponse!
    checkOutWithFace(input: checkOutWithFaceInput!): checkOutWithFaceResponse!
    
    checkIn(input: checkInInput!): checkInResponse!
    checkOut(input: checkOutInput!): checkOutResponse!
    
    save_package(packageInput: PackageInput!): Boolean
    update_package(packageUpdateInput: PackageUpdateInput!): Int
    delete_package(id: Int!): Boolean
    delete_temporary_employee(id: Int!): Boolean

    client_entry(clientInput: ClientInput!): Int 
    update_client(clientUpdateInput: ClientUpdateInput!): Boolean
    client_entity_entry(entitiesInput: EntitiesInput!): Boolean
    update_client_entity(entitiesUpdateInput: EntitiesUpdateInput!): Boolean
    update_client_service(serviceUpdateInput: ServiceUpdateInput!): Boolean

    save_vendorType(vendorTypeInput: VendorTypeInput!): Boolean
    delete_vendorType(id: Int!): Boolean
    update_vendorType(vendorTypeUpdateInput: VendorTypeUpdateInput!): Int

    save_vendor(vendorInput: VendorInput!): Int 
    save_vendor_payment(vendorPaymentInput: VendorPaymentInput!): VendorPayment
    update_vendor_payment(vendorPaymentUpdateInput: VendorPaymentInput!): Boolean
    update_vendor_Tax(vendorTaxUpdateInput: VendorTaxInput!): Boolean
    update_vendor(vendorUpdateInput: VendorUpdateInput!): Int
    delete_vendor(id: Int!): Boolean
  
    add_payment_term(paymentTermInput: PaymentTermInput!): PaymentTerm!

    save_chartAccount(chartAccountInput: ChartAccountInput!): Boolean
    update_ChartAccount(chartAccountUpdateInput: ChartAccountUpdateInput!): Boolean

    save_check(checkpaymentinput: CheckPaymentInput!): Checks
    update_check(checkpaymentUpdateInput: CheckPaymentInput!): Checks
    delete_check(id: Int!): Boolean
    delete_invitation(id: Int!): Boolean 

    save_expense_type(expenseTypeInput: ExpenseTypeInput!): Boolean
    update_expense_type(expenseTypeupdateInput: ExpenseTypeUpdateInput!): Boolean
    delete_expense_type(id: Int!): Boolean

    save_expense(expensesInput: ExpensesInput!): Boolean
    delete_expense(id: Int!): Boolean
    update_expense(expensesInput: ExpensesInput!): Boolean
    save_income_type(incomeTypeInput: IncomeTypeInput!): Boolean

    update_Profile(profileInput: ProfileInput!): updateProfileResponse
    change_Password(changePasswordInput: ChangePasswordInput!): changePasswordResponse
    update_employee_by_id(employeeUpdateInput: EmployeeUpdateInput!): Boolean
    reset_password(resetPasswordInput: ResetPasswordInput!): ResetPasswordResponse
    check_email_exists(emailInput: EmailInput!): EmailInputResponse

    swap_task(swapInput: SwapInput!): SwapInputResponse
    forward_task(forwardInput: ForwardInput!): ForwardInputResponse
    mark_approved_task_status(markApprovedTaskStatusInput: MarkApprovedTaskStatusInput!): Boolean
    mark_reject_task_status(markRejectTaskStatusInput: MarkRejectTaskStatusInput!): Boolean

    accept_consent(acceptInput: AcceptInput!): AcceptConsentResponse
    accept_consent_bulk(acceptInputbulk: AcceptInputBulk!): AcceptConsentBulkResponse

    save_service(serviceInput: ServiceInput!): Boolean

    update_service(serviceUpdateInput: ServiceUpdateInput!): Boolean

    save_employee_tasks(employee_taskInput: Employee_TaskInput!): Boolean

    save_task_history(task_history_input: Task_history_input!): Boolean

    save_sub_task(subTaskInput: SubTaskInput!): Boolean
    update_sub_task(updatesubTaskInput: UpdateSubTaskInput!): Boolean
    update_task_status(updateTaskStatusInput: UpdateTaskStatusInput!): Boolean!
    update_sub_task_status(updatesubTaskStatusInput: UpdatesubTaskStatusInput!): Boolean!
    save_task_comment(taskCommentInput: TaskCommentInput!): Boolean
    save_task_note(taskNoteInput: TaskNoteInput!): Boolean
    react_to_comment(reactToComment: ReactToCommentInput!): Boolean!
    delete_comment_reaction(comment_id: ID!, user_id: String!): Boolean!
    
    save_time_sheet(timeSheetInput: TimeSheetInput!): Int
    update_time_sheet(timeSheetInput: TimeSheetInput!): Boolean
    
  }
`
module.exports = makeExecutableSchema({ typeDefs, resolvers })
