import { db } from "../../firebase";

export const normalizeDdType = (ddType: string): string => {
  if (ddType === 'Major (M)') return 'M';
  if (ddType === 'Minor (N)') return 'N';
  return ddType || 'N';
};

export const normalizeMelCat = (cat: string): string => {
  if (cat.startsWith('Cat ')) return cat.replace('Cat ', '');
  return cat || 'A';
};

export const generateLogPageNo = async (): Promise<string> => {
  const logsSnapshot = await db
    .collection("logs")
    .orderBy("createdAt", "desc")
    .limit(1)
    .get();

  if (logsSnapshot.empty) return "LOG-00001";

  const lastLog = logsSnapshot.docs[0].data();
  const lastNo = lastLog.logPageNo?.split("-")[1] || "00000";
  const nextNo = (parseInt(lastNo) + 1).toString().padStart(5, "0");
  return `LOG-${nextNo}`;
};

export const generateDeferralTypeNo = async (): Promise<string> => {
  return db.runTransaction(async (transaction) => {
    const deferralsSnapshot = await transaction.get(
      db.collection("deferrals").orderBy("createdAt", "desc").limit(1)
    );

    if (deferralsSnapshot.empty) return "DEF-00001";

    const lastDeferral = deferralsSnapshot.docs[0].data();
    const lastTypeNo = lastDeferral.entries[0]?.defect_reference?.type_no || "DEF-00000";
    const numericPart = parseInt(lastTypeNo.replace("DEF-", ""), 10);
    if (isNaN(numericPart)) return "DEF-00001";
    return `DEF-${String(numericPart + 1).padStart(5, "0")}`;
  });
};