import JwtUtils from "../utils/jwtUtils";
import { Request, Response, NextFunction } from "express";
import { BadRequestError } from "../utils/ApiError";
import { BadRequestResponse } from "../utils/ApiResponse";

export default (req: any, res: Response, next: NextFunction) => {
    try {
        const token = req.headers["authorization"];
        if (!token) {
            return new BadRequestResponse("Access token required").send(res);
        }

        const accessToken = token.split(" ")[1];
        if (!accessToken) {
            return new BadRequestResponse("Access token required").send(res);
        }

        // Use verifyToken to check expiry (decodeToken doesn't verify expiry)
        try {
            const decoded = JwtUtils.verifyToken(accessToken);
            if (!decoded) {
                return new BadRequestResponse("Invalid access token").send(res);
            }

            req.user = decoded;
            next();
        } catch (verifyError: any) {
            if (verifyError.name === 'TokenExpiredError') {
                return res.status(401).json({
                    success: false,
                    message: "Token expired. Please login again.",
                    error: "TokenExpiredError"
                });
            }
            if (verifyError.name === 'JsonWebTokenError') {
                return res.status(401).json({
                    success: false,
                    message: "Invalid token",
                    error: "JsonWebTokenError"
                });
            }
            return new BadRequestResponse(verifyError?.message || "Token verification failed").send(res);
        }
    } catch (error: Error | any) {
        return new BadRequestResponse(error?.message || "Authentication error").send(res);
    }
}