import { BlockingFunction, CloudFunction, EventContext } from '../cloud-functions';
import { AuthEventContext, AuthUserRecord, BeforeCreateResponse, BeforeSignInResponse, HttpsError, UserInfo, UserRecord, userRecordConstructor, UserRecordMetadata } from '../common/providers/identity';
import { DeploymentOptions } from '../function-configuration';
export { UserRecord, UserInfo, UserRecordMetadata, userRecordConstructor };
export { HttpsError };
/** @hidden */
export declare const provider = "google.firebase.auth";
/** @hidden */
export declare const service = "firebaseauth.googleapis.com";
/**
 * Resource level options
 * @public
 */
export interface UserOptions {
    /** Options to set configuration at the resource level for blocking functions. */
    blockingOptions?: {
        /** Pass the ID Token credential to the function. */
        idToken?: boolean;
        /** Pass the Access Token credential to the function. */
        accessToken?: boolean;
        /** Pass the Refresh Token credential to the function. */
        refreshToken?: boolean;
    };
}
/**
 * Handles events related to Firebase authentication users.
 * @param userOptions - Resource level options
 * @returns UserBuilder - Builder used to create Cloud Functions for Firebase Auth user lifecycle events
 * @public
 */
export declare function user(userOptions?: UserOptions): UserBuilder;
/** @hidden */
export declare function _userWithOptions(options: DeploymentOptions, userOptions: UserOptions): UserBuilder;
/**
 * Builder used to create Cloud Functions for Firebase Auth user lifecycle events.
 * @public
 */
export declare class UserBuilder {
    private triggerResource;
    private options;
    private userOptions?;
    private static dataConstructor;
    /** @hidden */
    constructor(triggerResource: () => string, options: DeploymentOptions, userOptions?: UserOptions);
    /**
     * Responds to the creation of a Firebase Auth user.
     * @public
     */
    onCreate(handler: (user: UserRecord, context: EventContext) => PromiseLike<any> | any): CloudFunction<UserRecord>;
    /**
     * Responds to the deletion of a Firebase Auth user.
     * @public
     */
    onDelete(handler: (user: UserRecord, context: EventContext) => PromiseLike<any> | any): CloudFunction<UserRecord>;
    beforeCreate(handler: (user: AuthUserRecord, context: AuthEventContext) => BeforeCreateResponse | void | Promise<BeforeCreateResponse> | Promise<void>): BlockingFunction;
    beforeSignIn(handler: (user: AuthUserRecord, context: AuthEventContext) => BeforeSignInResponse | void | Promise<BeforeSignInResponse> | Promise<void>): BlockingFunction;
    /** @hidden */
    private onOperation;
    /** @hidden */
    private beforeOperation;
}
