/*! firebase-admin v8.13.0 */
"use strict";
/*!
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
var error_1 = require("../utils/error");
var instance_id_request_1 = require("./instance-id-request");
var validator = require("../utils/validator");
/**
 * Internals of an InstanceId service instance.
 */
var InstanceIdInternals = /** @class */ (function () {
    function InstanceIdInternals() {
    }
    /**
     * Deletes the service and its associated resources.
     *
     * @return {Promise<()>} An empty Promise that will be fulfilled when the service is deleted.
     */
    InstanceIdInternals.prototype.delete = function () {
        // There are no resources to clean up
        return Promise.resolve(undefined);
    };
    return InstanceIdInternals;
}());
var InstanceId = /** @class */ (function () {
    /**
     * @param {FirebaseApp} app The app for this InstanceId service.
     * @constructor
     */
    function InstanceId(app) {
        this.INTERNAL = new InstanceIdInternals();
        if (!validator.isNonNullObject(app) || !('options' in app)) {
            throw new error_1.FirebaseInstanceIdError(error_1.InstanceIdClientErrorCode.INVALID_ARGUMENT, 'First argument passed to admin.instanceId() must be a valid Firebase app instance.');
        }
        this.app_ = app;
        this.requestHandler = new instance_id_request_1.FirebaseInstanceIdRequestHandler(app);
    }
    /**
     * Deletes the specified instance ID from Firebase. This can be used to delete an instance ID
     * and associated user data from a Firebase project, pursuant to the General Data Protection
     * Regulation (GDPR).
     *
     * @param {string} instanceId The instance ID to be deleted
     * @return {Promise<void>} A promise that resolves when the instance ID is successfully deleted.
     */
    InstanceId.prototype.deleteInstanceId = function (instanceId) {
        return this.requestHandler.deleteInstanceId(instanceId)
            .then(function () {
            // Return nothing on success
        });
    };
    Object.defineProperty(InstanceId.prototype, "app", {
        /**
         * Returns the app associated with this InstanceId instance.
         *
         * @return {FirebaseApp} The app associated with this InstanceId instance.
         */
        get: function () {
            return this.app_;
        },
        enumerable: true,
        configurable: true
    });
    return InstanceId;
}());
exports.InstanceId = InstanceId;
