import * as admin from 'firebase-admin';
import { IFirebaseCredentials } from '../interfaces/IFirebaseCredentials';
declare const getCredentialsFromFile: (credentialsFilename: string) => Promise<IFirebaseCredentials>;
declare const getFirestoreDBReference: (credentials: IFirebaseCredentials) => FirebaseFirestore.Firestore;
declare const getDBReferenceFromPath: (db: FirebaseFirestore.Firestore, dataPath?: string | undefined) => FirebaseFirestore.Firestore | FirebaseFirestore.CollectionReference<FirebaseFirestore.DocumentData> | FirebaseFirestore.DocumentReference<FirebaseFirestore.DocumentData>;
declare const isLikeDocument: (ref: FirebaseFirestore.Firestore | FirebaseFirestore.CollectionReference<FirebaseFirestore.DocumentData> | FirebaseFirestore.DocumentReference<FirebaseFirestore.DocumentData>) => ref is FirebaseFirestore.DocumentReference<FirebaseFirestore.DocumentData>;
declare const isRootOfDatabase: (ref: FirebaseFirestore.Firestore | FirebaseFirestore.CollectionReference<FirebaseFirestore.DocumentData> | FirebaseFirestore.DocumentReference<FirebaseFirestore.DocumentData>) => ref is FirebaseFirestore.Firestore;
declare const sleep: (timeInMS: number) => Promise<void>;
declare const batchExecutor: <T>(promises: Promise<T>[], batchSize?: number) => Promise<T[]>;
declare const safelyGetCollectionsSnapshot: (startingRef: FirebaseFirestore.Firestore | FirebaseFirestore.DocumentReference<FirebaseFirestore.DocumentData>, logs?: boolean) => Promise<FirebaseFirestore.CollectionReference<FirebaseFirestore.DocumentData>[]>;
declare const safelyGetDocumentReferences: (collectionRef: FirebaseFirestore.CollectionReference<FirebaseFirestore.DocumentData>, logs?: boolean) => Promise<FirebaseFirestore.DocumentReference<FirebaseFirestore.DocumentData>[]>;
declare type anyFirebaseRef = admin.firestore.Firestore | FirebaseFirestore.DocumentReference | FirebaseFirestore.CollectionReference;
export { getCredentialsFromFile, getFirestoreDBReference, getDBReferenceFromPath, isLikeDocument, isRootOfDatabase, sleep, batchExecutor, anyFirebaseRef, safelyGetCollectionsSnapshot, safelyGetDocumentReferences, };
