export const generateNextLogPageNo = (existingPageNos: Array<string | undefined | null>): string => {
  if (!Array.isArray(existingPageNos) || existingPageNos.length === 0) {
    return "LOG-00001";
  }

  const numbers = existingPageNos
    .map((pageNo) => {
      if (typeof pageNo !== "string") return 0;
      const match = pageNo.match(/^LOG-(\d+)$/);
      return match ? parseInt(match[1], 10) : 0;
    })
    .filter((num) => Number.isFinite(num) && num > 0) as number[];

  const maxNumber = numbers.length > 0 ? Math.max(...numbers) : 0;
  const nextNumber = maxNumber + 1;
  return `LOG-${nextNumber.toString().padStart(5, "0")}`;
};