// src/router/flightRouter.ts
import { Router } from "express";
import FlightController from "../../controller/flightController";
import { verifyToken } from "../../middleware/verifyToken";

export default class FlightRouter {
  readonly router: Router = Router();
  private readonly flightCtrl = new FlightController();
    
  constructor() {
    this.initRoutes();
  }

  private initRoutes() {
    this.router.use(verifyToken);
    // ----- Flight CRUD -----
    this.router.post("/", this.flightCtrl.create);
    this.router.get("/", this.flightCtrl.getAll);
    this.router.get("/:id", this.flightCtrl.getOne);
    this.router.put("/:id", this.flightCtrl.update);
    this.router.delete("/:id", this.flightCtrl.delete);
    this.router.patch("/:id/make-current", this.flightCtrl.makeCurrent);

    // ----- List routes (exact same paths as before) -----
    this.router.post("/airports", this.flightCtrl.addAirport);
    this.router.get("/airports/list", this.flightCtrl.getAirports);
    this.router.get("/regns/list", this.flightCtrl.getRegns);
    this.router.get("/flightNos/list", this.flightCtrl.getFlightNos);
  }
}