import { Router } from "express";
import CheckController from "../../controller/checkController";
import { verifyToken } from "../../middleware/verifyToken";

export default class CheckRouter {
  router: Router;

  constructor() {
    this.router = Router();
    this.routes();
  }

  routes() {

    this.router.use(verifyToken);
    const checkController = new CheckController();
    
    // Save check authorizations
    this.router.post('/:logId/checks', checkController.saveChecks);
    
    // Get check authorizations
    this.router.get('/:logId/checks', checkController.getChecks);
  }
}