import { Router } from "express";
import AircraftController from "../../controller/aircraftController";
import upload from "../../middleware/uploadMiddleware";
import { verifyToken } from "../../middleware/verifyToken";

export default class AircraftRouter {
    readonly router: Router = Router();
    readonly controller: AircraftController = new AircraftController();

    constructor() {
        this.initRoutes();
    }

    initRoutes() {

        this.router.use(verifyToken);
            
        this.router.post('/', upload.single("image"), this.controller.create);
        this.router.get('/', this.controller.getAll);
        this.router.get('/:id', this.controller.getOne);
        this.router.put('/:id', upload.single("image"), this.controller.update);
        this.router.delete('/:id', this.controller.delete);
    }
}