import { Expression } from '../v2/params';
import { ParamSpec } from '../v2/params/types';
/**
 * An definition of a function as appears in the Manifest.
 */
export interface ManifestEndpoint {
    entryPoint?: string;
    region?: string[];
    platform?: string;
    availableMemoryMb?: number | Expression<number>;
    maxInstances?: number | Expression<number>;
    minInstances?: number | Expression<number>;
    concurrency?: number | Expression<number>;
    serviceAccountEmail?: string;
    timeoutSeconds?: number | Expression<number>;
    cpu?: number | 'gcf_gen1';
    vpc?: {
        connector: string | Expression<string>;
        egressSettings?: string;
    };
    labels?: Record<string, string>;
    ingressSettings?: string;
    environmentVariables?: Record<string, string>;
    secretEnvironmentVariables?: Array<{
        key: string;
        secret?: string;
    }>;
    httpsTrigger?: {
        invoker?: string[];
    };
    callableTrigger?: {};
    eventTrigger?: {
        eventFilters: Record<string, string | Expression<string>>;
        eventFilterPathPatterns?: Record<string, string | Expression<string>>;
        channel?: string;
        eventType: string;
        retry: boolean | Expression<boolean>;
        region?: string;
        serviceAccountEmail?: string;
    };
    scheduleTrigger?: {
        schedule?: string | Expression<string>;
        timeZone?: string | Expression<string>;
        retryConfig?: {
            retryCount?: number | Expression<number>;
            maxRetrySeconds?: string | Expression<string>;
            minBackoffSeconds?: string | Expression<string>;
            maxBackoffSeconds?: string | Expression<string>;
            maxDoublings?: number | Expression<number>;
        };
    };
    blockingTrigger?: {
        eventType: string;
        options?: Record<string, unknown>;
    };
}
export interface ManifestRequiredAPI {
    api: string;
    reason: string;
}
/**
 * An definition of a function deployment as appears in the Manifest.
 */
export interface ManifestStack {
    specVersion: 'v1alpha1';
    params?: ParamSpec[];
    requiredAPIs: ManifestRequiredAPI[];
    endpoints: Record<string, ManifestEndpoint>;
}
