"use strict";
// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **
Object.defineProperty(exports, "__esModule", { value: true });
const gax = require("google-gax");
const path = require("path");
const gapicConfig = require("./firestore_client_config.json");
const version = require('../../../package.json').version;
/**
 *  The Cloud Firestore service.
 *
 *  This service exposes several types of comparable timestamps:
 *
 *  *    `create_time` - The time at which a document was created. Changes only
 *       when a document is deleted, then re-created. Increases in a strict
 *        monotonic fashion.
 *  *    `update_time` - The time at which a document was last updated. Changes
 *       every time a document is modified. Does not change when a write results
 *       in no modifications. Increases in a strict monotonic fashion.
 *  *    `read_time` - The time at which a particular state was observed. Used
 *       to denote a consistent snapshot of the database or the time at which a
 *       Document was observed to not exist.
 *  *    `commit_time` - The time at which the writes in a transaction were
 *       committed. Any read with an equal or greater `read_time` is guaranteed
 *       to see the effects of the transaction.
 * @class
 * @memberof v1beta1
 */
class FirestoreClient {
    /**
     * Construct an instance of FirestoreClient.
     *
     * @param {object} [options] - The configuration object. See the subsequent
     *   parameters for more details.
     * @param {object} [options.credentials] - Credentials object.
     * @param {string} [options.credentials.client_email]
     * @param {string} [options.credentials.private_key]
     * @param {string} [options.email] - Account email address. Required when
     *     using a .pem or .p12 keyFilename.
     * @param {string} [options.keyFilename] - Full path to the a .json, .pem, or
     *     .p12 key downloaded from the Google Developers Console. If you provide
     *     a path to a JSON file, the projectId option below is not necessary.
     *     NOTE: .pem and .p12 require you to specify options.email as well.
     * @param {number} [options.port] - The port on which to connect to
     *     the remote host.
     * @param {string} [options.projectId] - The project ID from the Google
     *     Developer's Console, e.g. 'grape-spaceship-123'. We will also check
     *     the environment variable GCLOUD_PROJECT for your project ID. If your
     *     app is running in an environment which supports
     *     {@link https://developers.google.com/identity/protocols/application-default-credentials Application Default Credentials},
     *     your project ID will be detected automatically.
     * @param {string} [options.apiEndpoint] - The domain name of the
     *     API remote host.
     */
    constructor(opts) {
        this._descriptors = {
            page: {},
            stream: {},
            longrunning: {},
            batching: {},
        };
        this._terminated = false;
        // Ensure that options include the service address and port.
        const staticMembers = this.constructor;
        const servicePath = opts && opts.servicePath
            ? opts.servicePath
            : opts && opts.apiEndpoint
                ? opts.apiEndpoint
                : staticMembers.servicePath;
        const port = opts && opts.port ? opts.port : staticMembers.port;
        if (!opts) {
            opts = { servicePath, port };
        }
        opts.servicePath = opts.servicePath || servicePath;
        opts.port = opts.port || port;
        opts.clientConfig = opts.clientConfig || {};
        const isBrowser = typeof window !== 'undefined';
        if (isBrowser) {
            opts.fallback = true;
        }
        // If we are in browser, we are already using fallback because of the
        // "browser" field in package.json.
        // But if we were explicitly requested to use fallback, let's do it now.
        this._gaxModule = !isBrowser && opts.fallback ? gax.fallback : gax;
        // Create a `gaxGrpc` object, with any grpc-specific options
        // sent to the client.
        opts.scopes = this.constructor.scopes;
        this._gaxGrpc = new this._gaxModule.GrpcClient(opts);
        // Save options to use in initialize() method.
        this._opts = opts;
        // Save the auth object to the client, for use by other methods.
        this.auth = this._gaxGrpc.auth;
        // Determine the client header string.
        const clientHeader = [`gax/${this._gaxModule.version}`, `gapic/${version}`];
        if (typeof process !== 'undefined' && 'versions' in process) {
            clientHeader.push(`gl-node/${process.versions.node}`);
        }
        else {
            clientHeader.push(`gl-web/${this._gaxModule.version}`);
        }
        if (!opts.fallback) {
            clientHeader.push(`grpc/${this._gaxGrpc.grpcVersion}`);
        }
        if (opts.libName && opts.libVersion) {
            clientHeader.push(`${opts.libName}/${opts.libVersion}`);
        }
        // Load the applicable protos.
        // For Node.js, pass the path to JSON proto file.
        // For browsers, pass the JSON content.
        const nodejsProtoPath = path.join(__dirname, '..', '..', 'protos', 'protos.json');
        this._protos = this._gaxGrpc.loadProto(opts.fallback ? require('../../protos/protos.json') : nodejsProtoPath);
        // Some of the methods on this service return "paged" results,
        // (e.g. 50 results at a time, with tokens to get subsequent
        // pages). Denote the keys used for pagination and results.
        this._descriptors.page = {
            listDocuments: new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'documents'),
            listCollectionIds: new this._gaxModule.PageDescriptor('pageToken', 'nextPageToken', 'collectionIds'),
        };
        // Some of the methods on this service provide streaming responses.
        // Provide descriptors for these.
        this._descriptors.stream = {
            batchGetDocuments: new this._gaxModule.StreamDescriptor(gax.StreamType.SERVER_STREAMING),
            runQuery: new this._gaxModule.StreamDescriptor(gax.StreamType.SERVER_STREAMING),
            write: new this._gaxModule.StreamDescriptor(gax.StreamType.BIDI_STREAMING),
            listen: new this._gaxModule.StreamDescriptor(gax.StreamType.BIDI_STREAMING),
        };
        // Put together the default options sent with requests.
        this._defaults = this._gaxGrpc.constructSettings('google.firestore.v1beta1.Firestore', gapicConfig, opts.clientConfig || {}, { 'x-goog-api-client': clientHeader.join(' ') });
        // Set up a dictionary of "inner API calls"; the core implementation
        // of calling the API is handled in `google-gax`, with this code
        // merely providing the destination and request information.
        this._innerApiCalls = {};
    }
    /**
     * Initialize the client.
     * Performs asynchronous operations (such as authentication) and prepares the client.
     * This function will be called automatically when any class method is called for the
     * first time, but if you need to initialize it before calling an actual method,
     * feel free to call initialize() directly.
     *
     * You can await on this method if you want to make sure the client is initialized.
     *
     * @returns {Promise} A promise that resolves to an authenticated service stub.
     */
    initialize() {
        // If the client stub promise is already initialized, return immediately.
        if (this.firestoreStub) {
            return this.firestoreStub;
        }
        // Put together the "service stub" for
        // google.firestore.v1beta1.Firestore.
        this.firestoreStub = this._gaxGrpc.createStub(this._opts.fallback
            ? this._protos.lookupService('google.firestore.v1beta1.Firestore')
            : // tslint:disable-next-line no-any
                this._protos.google.firestore.v1beta1.Firestore, this._opts);
        // Iterate over each of the methods that the service provides
        // and create an API call method for each.
        const firestoreStubMethods = [
            'getDocument',
            'listDocuments',
            'createDocument',
            'updateDocument',
            'deleteDocument',
            'batchGetDocuments',
            'beginTransaction',
            'commit',
            'rollback',
            'runQuery',
            'write',
            'listen',
            'listCollectionIds',
        ];
        for (const methodName of firestoreStubMethods) {
            const innerCallPromise = this.firestoreStub.then(stub => (...args) => {
                if (this._terminated) {
                    return Promise.reject(new Error('The client has already been closed.'));
                }
                const func = stub[methodName];
                return func.apply(stub, args);
            }, (err) => () => {
                throw err;
            });
            const apiCall = this._gaxModule.createApiCall(innerCallPromise, this._defaults[methodName], this._descriptors.page[methodName] ||
                this._descriptors.stream[methodName] ||
                this._descriptors.longrunning[methodName]);
            this._innerApiCalls[methodName] = (argument, callOptions, callback) => {
                return apiCall(argument, callOptions, callback);
            };
        }
        return this.firestoreStub;
    }
    /**
     * The DNS address for this API service.
     */
    static get servicePath() {
        return 'firestore.googleapis.com';
    }
    /**
     * The DNS address for this API service - same as servicePath(),
     * exists for compatibility reasons.
     */
    static get apiEndpoint() {
        return 'firestore.googleapis.com';
    }
    /**
     * The port for this API service.
     */
    static get port() {
        return 443;
    }
    /**
     * The scopes needed to make gRPC calls for every method defined
     * in this service.
     */
    static get scopes() {
        return [
            'https://www.googleapis.com/auth/cloud-platform',
            'https://www.googleapis.com/auth/datastore',
        ];
    }
    /**
     * Return the project ID used by this class.
     * @param {function(Error, string)} callback - the callback to
     *   be called with the current project Id.
     */
    getProjectId(callback) {
        if (callback) {
            this.auth.getProjectId(callback);
            return;
        }
        return this.auth.getProjectId();
    }
    /**
     * Gets a single document.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. The resource name of the Document to get. In the format:
     *   `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * @param {google.firestore.v1beta1.DocumentMask} request.mask
     *   The fields to return. If not set, returns all fields.
     *
     *   If the document has a field that is not present in this mask, that field
     *   will not be returned in the response.
     * @param {Buffer} request.transaction
     *   Reads the document in a transaction.
     * @param {google.protobuf.Timestamp} request.readTime
     *   Reads the version of the document at the given time.
     *   This may not be older than 60 seconds.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Document]{@link google.firestore.v1beta1.Document}.
     *   The promise has a method named "cancel" which cancels the ongoing API call.
     */
    getDocument(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] = gax.routingHeader.fromParams({
            name: request.name || '',
        });
        this.initialize();
        return this._innerApiCalls.getDocument(request, options, callback);
    }
    /**
     * Creates a new document.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent resource. For example:
     *   `projects/{project_id}/databases/{database_id}/documents` or
     *   `projects/{project_id}/databases/{database_id}/documents/chatrooms/{chatroom_id}`
     * @param {string} request.collectionId
     *   Required. The collection ID, relative to `parent`, to list. For example: `chatrooms`.
     * @param {string} request.documentId
     *   The client-assigned document ID to use for this document.
     *
     *   Optional. If not specified, an ID will be assigned by the service.
     * @param {google.firestore.v1beta1.Document} request.document
     *   Required. The document to create. `name` must not be set.
     * @param {google.firestore.v1beta1.DocumentMask} request.mask
     *   The fields to return. If not set, returns all fields.
     *
     *   If the document has a field that is not present in this mask, that field
     *   will not be returned in the response.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Document]{@link google.firestore.v1beta1.Document}.
     *   The promise has a method named "cancel" which cancels the ongoing API call.
     */
    createDocument(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] = gax.routingHeader.fromParams({
            parent: request.parent || '',
        });
        this.initialize();
        return this._innerApiCalls.createDocument(request, options, callback);
    }
    /**
     * Updates or inserts a document.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {google.firestore.v1beta1.Document} request.document
     *   Required. The updated document.
     *   Creates the document if it does not already exist.
     * @param {google.firestore.v1beta1.DocumentMask} request.updateMask
     *   The fields to update.
     *   None of the field paths in the mask may contain a reserved name.
     *
     *   If the document exists on the server and has fields not referenced in the
     *   mask, they are left unchanged.
     *   Fields referenced in the mask, but not present in the input document, are
     *   deleted from the document on the server.
     * @param {google.firestore.v1beta1.DocumentMask} request.mask
     *   The fields to return. If not set, returns all fields.
     *
     *   If the document has a field that is not present in this mask, that field
     *   will not be returned in the response.
     * @param {google.firestore.v1beta1.Precondition} request.currentDocument
     *   An optional precondition on the document.
     *   The request will fail if this is set and not met by the target document.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Document]{@link google.firestore.v1beta1.Document}.
     *   The promise has a method named "cancel" which cancels the ongoing API call.
     */
    updateDocument(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] = gax.routingHeader.fromParams({
            'document.name': request.document.name || '',
        });
        this.initialize();
        return this._innerApiCalls.updateDocument(request, options, callback);
    }
    /**
     * Deletes a document.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. The resource name of the Document to delete. In the format:
     *   `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * @param {google.firestore.v1beta1.Precondition} request.currentDocument
     *   An optional precondition on the document.
     *   The request will fail if this is set and not met by the target document.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Empty]{@link google.protobuf.Empty}.
     *   The promise has a method named "cancel" which cancels the ongoing API call.
     */
    deleteDocument(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] = gax.routingHeader.fromParams({
            name: request.name || '',
        });
        this.initialize();
        return this._innerApiCalls.deleteDocument(request, options, callback);
    }
    /**
     * Starts a new transaction.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.database
     *   Required. The database name. In the format:
     *   `projects/{project_id}/databases/{database_id}`.
     * @param {google.firestore.v1beta1.TransactionOptions} request.options
     *   The options for the transaction.
     *   Defaults to a read-write transaction.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [BeginTransactionResponse]{@link google.firestore.v1beta1.BeginTransactionResponse}.
     *   The promise has a method named "cancel" which cancels the ongoing API call.
     */
    beginTransaction(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] = gax.routingHeader.fromParams({
            database: request.database || '',
        });
        this.initialize();
        return this._innerApiCalls.beginTransaction(request, options, callback);
    }
    /**
     * Commits a transaction, while optionally updating documents.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.database
     *   Required. The database name. In the format:
     *   `projects/{project_id}/databases/{database_id}`.
     * @param {number[]} request.writes
     *   The writes to apply.
     *
     *   Always executed atomically and in order.
     * @param {Buffer} request.transaction
     *   If set, applies all writes in this transaction, and commits it.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [CommitResponse]{@link google.firestore.v1beta1.CommitResponse}.
     *   The promise has a method named "cancel" which cancels the ongoing API call.
     */
    commit(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] = gax.routingHeader.fromParams({
            database: request.database || '',
        });
        this.initialize();
        return this._innerApiCalls.commit(request, options, callback);
    }
    /**
     * Rolls back a transaction.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.database
     *   Required. The database name. In the format:
     *   `projects/{project_id}/databases/{database_id}`.
     * @param {Buffer} request.transaction
     *   Required. The transaction to roll back.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Empty]{@link google.protobuf.Empty}.
     *   The promise has a method named "cancel" which cancels the ongoing API call.
     */
    rollback(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] = gax.routingHeader.fromParams({
            database: request.database || '',
        });
        this.initialize();
        return this._innerApiCalls.rollback(request, options, callback);
    }
    /**
     * Gets multiple documents.
     *
     * Documents returned by this method are not guaranteed to be returned in the
     * same order that they were requested.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.database
     *   Required. The database name. In the format:
     *   `projects/{project_id}/databases/{database_id}`.
     * @param {string[]} request.documents
     *   The names of the documents to retrieve. In the format:
     *   `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     *   The request will fail if any of the document is not a child resource of the
     *   given `database`. Duplicate names will be elided.
     * @param {google.firestore.v1beta1.DocumentMask} request.mask
     *   The fields to return. If not set, returns all fields.
     *
     *   If a document has a field that is not present in this mask, that field will
     *   not be returned in the response.
     * @param {Buffer} request.transaction
     *   Reads documents in a transaction.
     * @param {google.firestore.v1beta1.TransactionOptions} request.newTransaction
     *   Starts a new transaction and reads the documents.
     *   Defaults to a read-only transaction.
     *   The new transaction ID will be returned as the first response in the
     *   stream.
     * @param {google.protobuf.Timestamp} request.readTime
     *   Reads documents as they were at the given time.
     *   This may not be older than 60 seconds.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which emits [BatchGetDocumentsResponse]{@link google.firestore.v1beta1.BatchGetDocumentsResponse} on 'data' event.
     */
    batchGetDocuments(request, options) {
        request = request || {};
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] = gax.routingHeader.fromParams({
            database: request.database || '',
        });
        this.initialize();
        return this._innerApiCalls.batchGetDocuments(request, options);
    }
    /**
     * Runs a query.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent resource name. In the format:
     *   `projects/{project_id}/databases/{database_id}/documents` or
     *   `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     *   For example:
     *   `projects/my-project/databases/my-database/documents` or
     *   `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * @param {google.firestore.v1beta1.StructuredQuery} request.structuredQuery
     *   A structured query.
     * @param {Buffer} request.transaction
     *   Reads documents in a transaction.
     * @param {google.firestore.v1beta1.TransactionOptions} request.newTransaction
     *   Starts a new transaction and reads the documents.
     *   Defaults to a read-only transaction.
     *   The new transaction ID will be returned as the first response in the
     *   stream.
     * @param {google.protobuf.Timestamp} request.readTime
     *   Reads documents as they were at the given time.
     *   This may not be older than 60 seconds.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which emits [RunQueryResponse]{@link google.firestore.v1beta1.RunQueryResponse} on 'data' event.
     */
    runQuery(request, options) {
        request = request || {};
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] = gax.routingHeader.fromParams({
            parent: request.parent || '',
        });
        this.initialize();
        return this._innerApiCalls.runQuery(request, options);
    }
    /**
     * Streams batches of document updates and deletes, in order.
     *
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which is both readable and writable. It accepts objects
     *   representing [WriteRequest]{@link google.firestore.v1beta1.WriteRequest} for write() method, and
     *   will emit objects representing [WriteResponse]{@link google.firestore.v1beta1.WriteResponse} on 'data' event asynchronously.
     */
    write(options) {
        this.initialize();
        return this._innerApiCalls.write(options);
    }
    /**
     * Listens to changes.
     *
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which is both readable and writable. It accepts objects
     *   representing [ListenRequest]{@link google.firestore.v1beta1.ListenRequest} for write() method, and
     *   will emit objects representing [ListenResponse]{@link google.firestore.v1beta1.ListenResponse} on 'data' event asynchronously.
     */
    listen(options) {
        this.initialize();
        return this._innerApiCalls.listen({}, options);
    }
    /**
     * Lists documents.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent resource name. In the format:
     *   `projects/{project_id}/databases/{database_id}/documents` or
     *   `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     *   For example:
     *   `projects/my-project/databases/my-database/documents` or
     *   `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * @param {string} request.collectionId
     *   Required. The collection ID, relative to `parent`, to list. For example: `chatrooms`
     *   or `messages`.
     * @param {number} request.pageSize
     *   The maximum number of documents to return.
     * @param {string} request.pageToken
     *   The `next_page_token` value returned from a previous List request, if any.
     * @param {string} request.orderBy
     *   The order to sort results by. For example: `priority desc, name`.
     * @param {google.firestore.v1beta1.DocumentMask} request.mask
     *   The fields to return. If not set, returns all fields.
     *
     *   If a document has a field that is not present in this mask, that field
     *   will not be returned in the response.
     * @param {Buffer} request.transaction
     *   Reads documents in a transaction.
     * @param {google.protobuf.Timestamp} request.readTime
     *   Reads documents as they were at the given time.
     *   This may not be older than 60 seconds.
     * @param {boolean} request.showMissing
     *   If the list should show missing documents. A missing document is a
     *   document that does not exist but has sub-documents. These documents will
     *   be returned with a key but will not have fields, {@link google.firestore.v1beta1.Document.create_time|Document.create_time},
     *   or {@link google.firestore.v1beta1.Document.update_time|Document.update_time} set.
     *
     *   Requests with `show_missing` may not specify `where` or
     *   `order_by`.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is Array of [Document]{@link google.firestore.v1beta1.Document}.
     *   The client library support auto-pagination by default: it will call the API as many
     *   times as needed and will merge results from all the pages into this array.
     *
     *   When autoPaginate: false is specified through options, the array has three elements.
     *   The first element is Array of [Document]{@link google.firestore.v1beta1.Document} that corresponds to
     *   the one page received from the API server.
     *   If the second element is not null it contains the request object of type [ListDocumentsRequest]{@link google.firestore.v1beta1.ListDocumentsRequest}
     *   that can be used to obtain the next page of the results.
     *   If it is null, the next page does not exist.
     *   The third element contains the raw response received from the API server. Its type is
     *   [ListDocumentsResponse]{@link google.firestore.v1beta1.ListDocumentsResponse}.
     *
     *   The promise has a method named "cancel" which cancels the ongoing API call.
     */
    listDocuments(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] = gax.routingHeader.fromParams({
            parent: request.parent || '',
        });
        this.initialize();
        return this._innerApiCalls.listDocuments(request, options, callback);
    }
    /**
     * Equivalent to {@link listDocuments}, but returns a NodeJS Stream object.
     *
     * This fetches the paged responses for {@link listDocuments} continuously
     * and invokes the callback registered for 'data' event for each element in the
     * responses.
     *
     * The returned object has 'end' method when no more elements are required.
     *
     * autoPaginate option will be ignored.
     *
     * @see {@link https://nodejs.org/api/stream.html}
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent resource name. In the format:
     *   `projects/{project_id}/databases/{database_id}/documents` or
     *   `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     *   For example:
     *   `projects/my-project/databases/my-database/documents` or
     *   `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * @param {string} request.collectionId
     *   Required. The collection ID, relative to `parent`, to list. For example: `chatrooms`
     *   or `messages`.
     * @param {number} request.pageSize
     *   The maximum number of documents to return.
     * @param {string} request.pageToken
     *   The `next_page_token` value returned from a previous List request, if any.
     * @param {string} request.orderBy
     *   The order to sort results by. For example: `priority desc, name`.
     * @param {google.firestore.v1beta1.DocumentMask} request.mask
     *   The fields to return. If not set, returns all fields.
     *
     *   If a document has a field that is not present in this mask, that field
     *   will not be returned in the response.
     * @param {Buffer} request.transaction
     *   Reads documents in a transaction.
     * @param {google.protobuf.Timestamp} request.readTime
     *   Reads documents as they were at the given time.
     *   This may not be older than 60 seconds.
     * @param {boolean} request.showMissing
     *   If the list should show missing documents. A missing document is a
     *   document that does not exist but has sub-documents. These documents will
     *   be returned with a key but will not have fields, {@link google.firestore.v1beta1.Document.create_time|Document.create_time},
     *   or {@link google.firestore.v1beta1.Document.update_time|Document.update_time} set.
     *
     *   Requests with `show_missing` may not specify `where` or
     *   `order_by`.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which emits an object representing [Document]{@link google.firestore.v1beta1.Document} on 'data' event.
     */
    listDocumentsStream(request, options) {
        request = request || {};
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] = gax.routingHeader.fromParams({
            parent: request.parent || '',
        });
        const callSettings = new gax.CallSettings(options);
        this.initialize();
        return this._descriptors.page.listDocuments.createStream(this._innerApiCalls.listDocuments, request, callSettings);
    }
    /**
     * Lists all the collection IDs underneath a document.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent document. In the format:
     *   `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     *   For example:
     *   `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * @param {number} request.pageSize
     *   The maximum number of results to return.
     * @param {string} request.pageToken
     *   A page token. Must be a value from
     *   {@link google.firestore.v1beta1.ListCollectionIdsResponse|ListCollectionIdsResponse}.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is Array of string.
     *   The client library support auto-pagination by default: it will call the API as many
     *   times as needed and will merge results from all the pages into this array.
     *
     *   When autoPaginate: false is specified through options, the array has three elements.
     *   The first element is Array of string that corresponds to
     *   the one page received from the API server.
     *   If the second element is not null it contains the request object of type [ListCollectionIdsRequest]{@link google.firestore.v1beta1.ListCollectionIdsRequest}
     *   that can be used to obtain the next page of the results.
     *   If it is null, the next page does not exist.
     *   The third element contains the raw response received from the API server. Its type is
     *   [ListCollectionIdsResponse]{@link google.firestore.v1beta1.ListCollectionIdsResponse}.
     *
     *   The promise has a method named "cancel" which cancels the ongoing API call.
     */
    listCollectionIds(request, optionsOrCallback, callback) {
        request = request || {};
        let options;
        if (typeof optionsOrCallback === 'function' && callback === undefined) {
            callback = optionsOrCallback;
            options = {};
        }
        else {
            options = optionsOrCallback;
        }
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] = gax.routingHeader.fromParams({
            parent: request.parent || '',
        });
        this.initialize();
        return this._innerApiCalls.listCollectionIds(request, options, callback);
    }
    /**
     * Equivalent to {@link listCollectionIds}, but returns a NodeJS Stream object.
     *
     * This fetches the paged responses for {@link listCollectionIds} continuously
     * and invokes the callback registered for 'data' event for each element in the
     * responses.
     *
     * The returned object has 'end' method when no more elements are required.
     *
     * autoPaginate option will be ignored.
     *
     * @see {@link https://nodejs.org/api/stream.html}
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent document. In the format:
     *   `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     *   For example:
     *   `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * @param {number} request.pageSize
     *   The maximum number of results to return.
     * @param {string} request.pageToken
     *   A page token. Must be a value from
     *   {@link google.firestore.v1beta1.ListCollectionIdsResponse|ListCollectionIdsResponse}.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which emits an object representing string on 'data' event.
     */
    listCollectionIdsStream(request, options) {
        request = request || {};
        options = options || {};
        options.otherArgs = options.otherArgs || {};
        options.otherArgs.headers = options.otherArgs.headers || {};
        options.otherArgs.headers['x-goog-request-params'] = gax.routingHeader.fromParams({
            parent: request.parent || '',
        });
        const callSettings = new gax.CallSettings(options);
        this.initialize();
        return this._descriptors.page.listCollectionIds.createStream(this._innerApiCalls.listCollectionIds, request, callSettings);
    }
    /**
     * Terminate the GRPC channel and close the client.
     *
     * The client will no longer be usable and all future behavior is undefined.
     */
    close() {
        this.initialize();
        if (!this._terminated) {
            return this.firestoreStub.then(stub => {
                this._terminated = true;
                stub.close();
            });
        }
        return Promise.resolve();
    }
}
exports.FirestoreClient = FirestoreClient;
//# sourceMappingURL=firestore_client.js.map